
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.EnvoyConfigObjectMatch.ObjectTypes;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "routeConfiguration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class RouteConfigurationObjectTypes implements Serializable, ObjectTypes
{

    /**
     * 
     */
    @JsonProperty("routeConfiguration")
    @JsonPropertyDescription("")
    private RouteConfigurationMatch routeConfiguration;
    private final static long serialVersionUID = -1481803274776271756L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RouteConfigurationObjectTypes() {
    }

    /**
     * 
     * @param routeConfiguration
     */
    public RouteConfigurationObjectTypes(RouteConfigurationMatch routeConfiguration) {
        super();
        this.routeConfiguration = routeConfiguration;
    }

    /**
     * 
     */
    public RouteConfigurationMatch getRouteConfiguration() {
        return routeConfiguration;
    }

    /**
     * 
     */
    public void setRouteConfiguration(RouteConfigurationMatch routeConfiguration) {
        this.routeConfiguration = routeConfiguration;
    }

}
