package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteConfigurationObjectTypesBuilder extends RouteConfigurationObjectTypesFluentImpl<RouteConfigurationObjectTypesBuilder> implements VisitableBuilder<RouteConfigurationObjectTypes,RouteConfigurationObjectTypesBuilder>{

    RouteConfigurationObjectTypesFluent<?> fluent;
    Boolean validationEnabled;

    public RouteConfigurationObjectTypesBuilder(){
            this(true);
    }
    public RouteConfigurationObjectTypesBuilder(Boolean validationEnabled){
            this(new RouteConfigurationObjectTypes(), validationEnabled);
    }
    public RouteConfigurationObjectTypesBuilder(RouteConfigurationObjectTypesFluent<?> fluent){
            this(fluent, true);
    }
    public RouteConfigurationObjectTypesBuilder(RouteConfigurationObjectTypesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteConfigurationObjectTypes(), validationEnabled);
    }
    public RouteConfigurationObjectTypesBuilder(RouteConfigurationObjectTypesFluent<?> fluent,RouteConfigurationObjectTypes instance){
            this(fluent, instance, true);
    }
    public RouteConfigurationObjectTypesBuilder(RouteConfigurationObjectTypesFluent<?> fluent,RouteConfigurationObjectTypes instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRouteConfiguration(instance.getRouteConfiguration()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteConfigurationObjectTypesBuilder(RouteConfigurationObjectTypes instance){
            this(instance,true);
    }
    public RouteConfigurationObjectTypesBuilder(RouteConfigurationObjectTypes instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRouteConfiguration(instance.getRouteConfiguration()); 
            this.validationEnabled = validationEnabled; 
    }

    public RouteConfigurationObjectTypes build(){
            RouteConfigurationObjectTypes buildable = new RouteConfigurationObjectTypes(fluent.getRouteConfiguration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteConfigurationObjectTypesBuilder that = (RouteConfigurationObjectTypesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
