package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteMatchBuilder extends RouteMatchFluentImpl<RouteMatchBuilder> implements VisitableBuilder<RouteMatch,RouteMatchBuilder>{

    RouteMatchFluent<?> fluent;
    Boolean validationEnabled;

    public RouteMatchBuilder(){
            this(true);
    }
    public RouteMatchBuilder(Boolean validationEnabled){
            this(new RouteMatch(), validationEnabled);
    }
    public RouteMatchBuilder(RouteMatchFluent<?> fluent){
            this(fluent, true);
    }
    public RouteMatchBuilder(RouteMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteMatch(), validationEnabled);
    }
    public RouteMatchBuilder(RouteMatchFluent<?> fluent,RouteMatch instance){
            this(fluent, instance, true);
    }
    public RouteMatchBuilder(RouteMatchFluent<?> fluent,RouteMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAction(instance.getAction()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteMatchBuilder(RouteMatch instance){
            this(instance,true);
    }
    public RouteMatchBuilder(RouteMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAction(instance.getAction()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public RouteMatch build(){
            RouteMatch buildable = new RouteMatch(fluent.getAction(),fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteMatchBuilder that = (RouteMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
