package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class RouteMatchFluentImpl<A extends RouteMatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RouteMatchFluent<A>{

    private Action action;
    private String name;

    public RouteMatchFluentImpl(){
    }
    public RouteMatchFluentImpl(RouteMatch instance){
            this.withAction(instance.getAction()); 
            this.withName(instance.getName()); 
    }

    public Action getAction(){
            return this.action;
    }

    public A withAction(Action action){
            this.action=action; return (A) this;
    }

    public Boolean hasAction(){
            return this.action != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RouteMatchFluentImpl that = (RouteMatchFluentImpl) o;
            if (action != null ? !action.equals(that.action) :that.action != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }




}
