
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "caCertificates",
    "cipherSuites",
    "credentialName",
    "httpsRedirect",
    "maxProtocolVersion",
    "minProtocolVersion",
    "mode",
    "privateKey",
    "serverCertificate",
    "subjectAltNames",
    "verifyCertificateHash",
    "verifyCertificateSpki"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ServerTLSSettings implements Serializable
{

    /**
     * 
     */
    @JsonProperty("caCertificates")
    @JsonPropertyDescription("")
    private String caCertificates;
    /**
     * 
     */
    @JsonProperty("cipherSuites")
    @JsonPropertyDescription("")
    private List<String> cipherSuites = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("credentialName")
    @JsonPropertyDescription("")
    private String credentialName;
    /**
     * 
     */
    @JsonProperty("httpsRedirect")
    @JsonPropertyDescription("")
    private Boolean httpsRedirect;
    @JsonProperty("maxProtocolVersion")
    private me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettingsProtocol maxProtocolVersion;
    @JsonProperty("minProtocolVersion")
    private me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettingsProtocol minProtocolVersion;
    @JsonProperty("mode")
    private ServerTLSSettingsMode mode;
    /**
     * 
     */
    @JsonProperty("privateKey")
    @JsonPropertyDescription("")
    private String privateKey;
    /**
     * 
     */
    @JsonProperty("serverCertificate")
    @JsonPropertyDescription("")
    private String serverCertificate;
    /**
     * 
     */
    @JsonProperty("subjectAltNames")
    @JsonPropertyDescription("")
    private List<String> subjectAltNames = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("verifyCertificateHash")
    @JsonPropertyDescription("")
    private List<String> verifyCertificateHash = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("verifyCertificateSpki")
    @JsonPropertyDescription("")
    private List<String> verifyCertificateSpki = new ArrayList<String>();
    private final static long serialVersionUID = 7295849588322815682L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServerTLSSettings() {
    }

    /**
     * 
     * @param mode
     * @param privateKey
     * @param caCertificates
     * @param serverCertificate
     * @param cipherSuites
     * @param httpsRedirect
     * @param verifyCertificateHash
     * @param verifyCertificateSpki
     * @param maxProtocolVersion
     * @param subjectAltNames
     * @param credentialName
     * @param minProtocolVersion
     */
    public ServerTLSSettings(String caCertificates, List<String> cipherSuites, String credentialName, Boolean httpsRedirect, me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettingsProtocol maxProtocolVersion, me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettingsProtocol minProtocolVersion, ServerTLSSettingsMode mode, String privateKey, String serverCertificate, List<String> subjectAltNames, List<String> verifyCertificateHash, List<String> verifyCertificateSpki) {
        super();
        this.caCertificates = caCertificates;
        this.cipherSuites = cipherSuites;
        this.credentialName = credentialName;
        this.httpsRedirect = httpsRedirect;
        this.maxProtocolVersion = maxProtocolVersion;
        this.minProtocolVersion = minProtocolVersion;
        this.mode = mode;
        this.privateKey = privateKey;
        this.serverCertificate = serverCertificate;
        this.subjectAltNames = subjectAltNames;
        this.verifyCertificateHash = verifyCertificateHash;
        this.verifyCertificateSpki = verifyCertificateSpki;
    }

    /**
     * 
     */
    public String getCaCertificates() {
        return caCertificates;
    }

    /**
     * 
     */
    public void setCaCertificates(String caCertificates) {
        this.caCertificates = caCertificates;
    }

    /**
     * 
     */
    public List<String> getCipherSuites() {
        return cipherSuites;
    }

    /**
     * 
     */
    public void setCipherSuites(List<String> cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    /**
     * 
     */
    public String getCredentialName() {
        return credentialName;
    }

    /**
     * 
     */
    public void setCredentialName(String credentialName) {
        this.credentialName = credentialName;
    }

    /**
     * 
     */
    public Boolean getHttpsRedirect() {
        return httpsRedirect;
    }

    /**
     * 
     */
    public void setHttpsRedirect(Boolean httpsRedirect) {
        this.httpsRedirect = httpsRedirect;
    }

    public me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettingsProtocol getMaxProtocolVersion() {
        return maxProtocolVersion;
    }

    public void setMaxProtocolVersion(me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettingsProtocol maxProtocolVersion) {
        this.maxProtocolVersion = maxProtocolVersion;
    }

    public me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettingsProtocol getMinProtocolVersion() {
        return minProtocolVersion;
    }

    public void setMinProtocolVersion(me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettingsProtocol minProtocolVersion) {
        this.minProtocolVersion = minProtocolVersion;
    }

    public ServerTLSSettingsMode getMode() {
        return mode;
    }

    public void setMode(ServerTLSSettingsMode mode) {
        this.mode = mode;
    }

    /**
     * 
     */
    public String getPrivateKey() {
        return privateKey;
    }

    /**
     * 
     */
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    /**
     * 
     */
    public String getServerCertificate() {
        return serverCertificate;
    }

    /**
     * 
     */
    public void setServerCertificate(String serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    /**
     * 
     */
    public List<String> getSubjectAltNames() {
        return subjectAltNames;
    }

    /**
     * 
     */
    public void setSubjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
    }

    /**
     * 
     */
    public List<String> getVerifyCertificateHash() {
        return verifyCertificateHash;
    }

    /**
     * 
     */
    public void setVerifyCertificateHash(List<String> verifyCertificateHash) {
        this.verifyCertificateHash = verifyCertificateHash;
    }

    /**
     * 
     */
    public List<String> getVerifyCertificateSpki() {
        return verifyCertificateSpki;
    }

    /**
     * 
     */
    public void setVerifyCertificateSpki(List<String> verifyCertificateSpki) {
        this.verifyCertificateSpki = verifyCertificateSpki;
    }

}
