package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ServerTLSSettingsFluent<A extends ServerTLSSettingsFluent<A>> extends Fluent<A>{


    public String getCaCertificates();
    public A withCaCertificates(String caCertificates);
    public Boolean hasCaCertificates();
    public A withNewCaCertificates(String arg1);
    public A withNewCaCertificates(StringBuilder arg1);
    public A withNewCaCertificates(StringBuffer arg1);
    public A addToCipherSuites(int index,String item);
    public A setToCipherSuites(int index,String item);
    public A addToCipherSuites(String... items);
    public A addAllToCipherSuites(Collection<String> items);
    public A removeFromCipherSuites(String... items);
    public A removeAllFromCipherSuites(Collection<String> items);
    public List<String> getCipherSuites();
    public String getCipherSuite(int index);
    public String getFirstCipherSuite();
    public String getLastCipherSuite();
    public String getMatchingCipherSuite(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingCipherSuite(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withCipherSuites(List<String> cipherSuites);
    public A withCipherSuites(String... cipherSuites);
    public Boolean hasCipherSuites();
    public A addNewCipherSuite(String arg1);
    public A addNewCipherSuite(StringBuilder arg1);
    public A addNewCipherSuite(StringBuffer arg1);
    public String getCredentialName();
    public A withCredentialName(String credentialName);
    public Boolean hasCredentialName();
    public A withNewCredentialName(String arg1);
    public A withNewCredentialName(StringBuilder arg1);
    public A withNewCredentialName(StringBuffer arg1);
    public Boolean isHttpsRedirect();
    public A withHttpsRedirect(Boolean httpsRedirect);
    public Boolean hasHttpsRedirect();
    public A withNewHttpsRedirect(String arg1);
    public A withNewHttpsRedirect(boolean arg1);
    public ServerTLSSettingsProtocol getMaxProtocolVersion();
    public A withMaxProtocolVersion(ServerTLSSettingsProtocol maxProtocolVersion);
    public Boolean hasMaxProtocolVersion();
    public ServerTLSSettingsProtocol getMinProtocolVersion();
    public A withMinProtocolVersion(ServerTLSSettingsProtocol minProtocolVersion);
    public Boolean hasMinProtocolVersion();
    public ServerTLSSettingsMode getMode();
    public A withMode(ServerTLSSettingsMode mode);
    public Boolean hasMode();
    public String getPrivateKey();
    public A withPrivateKey(String privateKey);
    public Boolean hasPrivateKey();
    public A withNewPrivateKey(String arg1);
    public A withNewPrivateKey(StringBuilder arg1);
    public A withNewPrivateKey(StringBuffer arg1);
    public String getServerCertificate();
    public A withServerCertificate(String serverCertificate);
    public Boolean hasServerCertificate();
    public A withNewServerCertificate(String arg1);
    public A withNewServerCertificate(StringBuilder arg1);
    public A withNewServerCertificate(StringBuffer arg1);
    public A addToSubjectAltNames(int index,String item);
    public A setToSubjectAltNames(int index,String item);
    public A addToSubjectAltNames(String... items);
    public A addAllToSubjectAltNames(Collection<String> items);
    public A removeFromSubjectAltNames(String... items);
    public A removeAllFromSubjectAltNames(Collection<String> items);
    public List<String> getSubjectAltNames();
    public String getSubjectAltName(int index);
    public String getFirstSubjectAltName();
    public String getLastSubjectAltName();
    public String getMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withSubjectAltNames(List<String> subjectAltNames);
    public A withSubjectAltNames(String... subjectAltNames);
    public Boolean hasSubjectAltNames();
    public A addNewSubjectAltName(String arg1);
    public A addNewSubjectAltName(StringBuilder arg1);
    public A addNewSubjectAltName(StringBuffer arg1);
    public A addToVerifyCertificateHash(int index,String item);
    public A setToVerifyCertificateHash(int index,String item);
    public A addToVerifyCertificateHash(String... items);
    public A addAllToVerifyCertificateHash(Collection<String> items);
    public A removeFromVerifyCertificateHash(String... items);
    public A removeAllFromVerifyCertificateHash(Collection<String> items);
    public List<String> getVerifyCertificateHash();
    public String getVerifyCertificateHash(int index);
    public String getFirstVerifyCertificateHash();
    public String getLastVerifyCertificateHash();
    public String getMatchingVerifyCertificateHash(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingVerifyCertificateHash(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withVerifyCertificateHash(List<String> verifyCertificateHash);
    public A withVerifyCertificateHash(String... verifyCertificateHash);
    public Boolean hasVerifyCertificateHash();
    public A addNewVerifyCertificateHash(String arg1);
    public A addNewVerifyCertificateHash(StringBuilder arg1);
    public A addNewVerifyCertificateHash(StringBuffer arg1);
    public A addToVerifyCertificateSpki(int index,String item);
    public A setToVerifyCertificateSpki(int index,String item);
    public A addToVerifyCertificateSpki(String... items);
    public A addAllToVerifyCertificateSpki(Collection<String> items);
    public A removeFromVerifyCertificateSpki(String... items);
    public A removeAllFromVerifyCertificateSpki(Collection<String> items);
    public List<String> getVerifyCertificateSpki();
    public String getVerifyCertificateSpki(int index);
    public String getFirstVerifyCertificateSpki();
    public String getLastVerifyCertificateSpki();
    public String getMatchingVerifyCertificateSpki(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingVerifyCertificateSpki(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withVerifyCertificateSpki(List<String> verifyCertificateSpki);
    public A withVerifyCertificateSpki(String... verifyCertificateSpki);
    public Boolean hasVerifyCertificateSpki();
    public A addNewVerifyCertificateSpki(String arg1);
    public A addNewVerifyCertificateSpki(StringBuilder arg1);
    public A addNewVerifyCertificateSpki(StringBuffer arg1);



}
