package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceEntryListBuilder extends ServiceEntryListFluentImpl<ServiceEntryListBuilder> implements VisitableBuilder<ServiceEntryList,ServiceEntryListBuilder>{

    ServiceEntryListFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceEntryListBuilder(){
            this(true);
    }
    public ServiceEntryListBuilder(Boolean validationEnabled){
            this(new ServiceEntryList(), validationEnabled);
    }
    public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceEntryList(), validationEnabled);
    }
    public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent,ServiceEntryList instance){
            this(fluent, instance, true);
    }
    public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent,ServiceEntryList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceEntryListBuilder(ServiceEntryList instance){
            this(instance,true);
    }
    public ServiceEntryListBuilder(ServiceEntryList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceEntryList build(){
            ServiceEntryList buildable = new ServiceEntryList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceEntryListBuilder that = (ServiceEntryListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
