
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "addresses",
    "endpoints",
    "exportTo",
    "hosts",
    "location",
    "ports",
    "resolution",
    "subjectAltNames",
    "workloadSelector"
})
@IstioKind(name = "ServiceEntry", plural = "serviceentries")
@IstioApiVersion("networking.istio.io/v1alpha3")
@Version("v1alpha3")
@Group("networking.istio.io")
@Plural("serviceentries")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class ServiceEntrySpec implements Serializable, IstioSpec
{

    /**
     * 
     */
    @JsonProperty("addresses")
    @JsonPropertyDescription("")
    private List<String> addresses = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("endpoints")
    @JsonPropertyDescription("")
    private List<WorkloadEntrySpec> endpoints = new ArrayList<WorkloadEntrySpec>();
    /**
     * 
     */
    @JsonProperty("exportTo")
    @JsonPropertyDescription("")
    private List<String> exportTo = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("hosts")
    @JsonPropertyDescription("")
    private List<String> hosts = new ArrayList<String>();
    @JsonProperty("location")
    private ServiceEntryLocation location;
    /**
     * 
     */
    @JsonProperty("ports")
    @JsonPropertyDescription("")
    private List<Port> ports = new ArrayList<Port>();
    @JsonProperty("resolution")
    private ServiceEntryResolution resolution;
    /**
     * 
     */
    @JsonProperty("subjectAltNames")
    @JsonPropertyDescription("")
    private List<String> subjectAltNames = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("workloadSelector")
    @JsonPropertyDescription("")
    private WorkloadSelector workloadSelector;
    private final static long serialVersionUID = 3551472957190373037L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServiceEntrySpec() {
    }

    /**
     * 
     * @param addresses
     * @param endpoints
     * @param workloadSelector
     * @param hosts
     * @param location
     * @param subjectAltNames
     * @param exportTo
     * @param ports
     * @param resolution
     */
    public ServiceEntrySpec(List<String> addresses, List<WorkloadEntrySpec> endpoints, List<String> exportTo, List<String> hosts, ServiceEntryLocation location, List<Port> ports, ServiceEntryResolution resolution, List<String> subjectAltNames, WorkloadSelector workloadSelector) {
        super();
        this.addresses = addresses;
        this.endpoints = endpoints;
        this.exportTo = exportTo;
        this.hosts = hosts;
        this.location = location;
        this.ports = ports;
        this.resolution = resolution;
        this.subjectAltNames = subjectAltNames;
        this.workloadSelector = workloadSelector;
    }

    /**
     * 
     */
    public List<String> getAddresses() {
        return addresses;
    }

    /**
     * 
     */
    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    /**
     * 
     */
    public List<WorkloadEntrySpec> getEndpoints() {
        return endpoints;
    }

    /**
     * 
     */
    public void setEndpoints(List<WorkloadEntrySpec> endpoints) {
        this.endpoints = endpoints;
    }

    /**
     * 
     */
    public List<String> getExportTo() {
        return exportTo;
    }

    /**
     * 
     */
    public void setExportTo(List<String> exportTo) {
        this.exportTo = exportTo;
    }

    /**
     * 
     */
    public List<String> getHosts() {
        return hosts;
    }

    /**
     * 
     */
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public ServiceEntryLocation getLocation() {
        return location;
    }

    public void setLocation(ServiceEntryLocation location) {
        this.location = location;
    }

    /**
     * 
     */
    public List<Port> getPorts() {
        return ports;
    }

    /**
     * 
     */
    public void setPorts(List<Port> ports) {
        this.ports = ports;
    }

    public ServiceEntryResolution getResolution() {
        return resolution;
    }

    public void setResolution(ServiceEntryResolution resolution) {
        this.resolution = resolution;
    }

    /**
     * 
     */
    public List<String> getSubjectAltNames() {
        return subjectAltNames;
    }

    /**
     * 
     */
    public void setSubjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
    }

    /**
     * 
     */
    public WorkloadSelector getWorkloadSelector() {
        return workloadSelector;
    }

    /**
     * 
     */
    public void setWorkloadSelector(WorkloadSelector workloadSelector) {
        this.workloadSelector = workloadSelector;
    }

}
