package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class ServiceEntrySpecFluentImpl<A extends ServiceEntrySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceEntrySpecFluent<A>{

    private List<String> addresses;
    private List<WorkloadEntrySpecBuilder> endpoints;
    private List<String> exportTo;
    private List<String> hosts;
    private ServiceEntryLocation location;
    private List<PortBuilder> ports;
    private ServiceEntryResolution resolution;
    private List<String> subjectAltNames;
    private WorkloadSelectorBuilder workloadSelector;

    public ServiceEntrySpecFluentImpl(){
    }
    public ServiceEntrySpecFluentImpl(ServiceEntrySpec instance){
            this.withAddresses(instance.getAddresses()); 
            this.withEndpoints(instance.getEndpoints()); 
            this.withExportTo(instance.getExportTo()); 
            this.withHosts(instance.getHosts()); 
            this.withLocation(instance.getLocation()); 
            this.withPorts(instance.getPorts()); 
            this.withResolution(instance.getResolution()); 
            this.withSubjectAltNames(instance.getSubjectAltNames()); 
            this.withWorkloadSelector(instance.getWorkloadSelector()); 
    }

    public A addToAddresses(int index,String item){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            this.addresses.add(index, item);
            return (A)this;
    }

    public A setToAddresses(int index,String item){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            this.addresses.set(index, item); return (A)this;
    }

    public A addToAddresses(String... items){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            for (String item : items) {this.addresses.add(item);} return (A)this;
    }

    public A addAllToAddresses(Collection<String> items){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            for (String item : items) {this.addresses.add(item);} return (A)this;
    }

    public A removeFromAddresses(String... items){
            for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
    }

    public A removeAllFromAddresses(Collection<String> items){
            for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
    }

    public List<String> getAddresses(){
            return this.addresses;
    }

    public String getAddress(int index){
            return this.addresses.get(index);
    }

    public String getFirstAddress(){
            return this.addresses.get(0);
    }

    public String getLastAddress(){
            return this.addresses.get(addresses.size() - 1);
    }

    public String getMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: addresses) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: addresses) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAddresses(List<String> addresses){
            if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
            if (addresses != null) {this.addresses = new ArrayList<String>(); for (String item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
    }

    public A withAddresses(String... addresses){
            if (this.addresses != null) {this.addresses.clear();}
            if (addresses != null) {for (String item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public Boolean hasAddresses(){
            return addresses != null && !addresses.isEmpty();
    }

    public A addNewAddress(String arg1){
            return (A)addToAddresses(new String(arg1));
    }

    public A addNewAddress(StringBuilder arg1){
            return (A)addToAddresses(new String(arg1));
    }

    public A addNewAddress(StringBuffer arg1){
            return (A)addToAddresses(new String(arg1));
    }

    public A addToEndpoints(int index,WorkloadEntrySpec item){
            if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
            WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(index >= 0 ? index : _visitables.get("endpoints").size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
    }

    public A setToEndpoints(int index,WorkloadEntrySpec item){
            if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
            WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);
            if (index < 0 || index >= _visitables.get("endpoints").size()) { _visitables.get("endpoints").add(builder); } else { _visitables.get("endpoints").set(index, builder);}
            if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
             return (A)this;
    }

    public A addToEndpoints(WorkloadEntrySpec... items){
            if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
            for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
    }

    public A addAllToEndpoints(Collection<WorkloadEntrySpec> items){
            if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
            for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
    }

    public A removeFromEndpoints(WorkloadEntrySpec... items){
            for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
    }

    public A removeAllFromEndpoints(Collection<WorkloadEntrySpec> items){
            for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEndpoints(io.fabric8.kubernetes.api.builder.Predicate<WorkloadEntrySpecBuilder> predicate){
            if (endpoints == null) return (A) this;
            final Iterator<WorkloadEntrySpecBuilder> each = endpoints.iterator();
            final List visitables = _visitables.get("endpoints");
            while (each.hasNext()) {
              WorkloadEntrySpecBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<WorkloadEntrySpec> getEndpoints(){
            return build(endpoints);
    }

    public List<WorkloadEntrySpec> buildEndpoints(){
            return build(endpoints);
    }

    public WorkloadEntrySpec buildEndpoint(int index){
            return this.endpoints.get(index).build();
    }

    public WorkloadEntrySpec buildFirstEndpoint(){
            return this.endpoints.get(0).build();
    }

    public WorkloadEntrySpec buildLastEndpoint(){
            return this.endpoints.get(endpoints.size() - 1).build();
    }

    public WorkloadEntrySpec buildMatchingEndpoint(io.fabric8.kubernetes.api.builder.Predicate<WorkloadEntrySpecBuilder> predicate){
            for (WorkloadEntrySpecBuilder item: endpoints) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEndpoint(io.fabric8.kubernetes.api.builder.Predicate<WorkloadEntrySpecBuilder> predicate){
            for (WorkloadEntrySpecBuilder item: endpoints) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEndpoints(List<WorkloadEntrySpec> endpoints){
            if (this.endpoints != null) { _visitables.get("endpoints").removeAll(this.endpoints);}
            if (endpoints != null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>(); for (WorkloadEntrySpec item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
    }

    public A withEndpoints(WorkloadEntrySpec... endpoints){
            if (this.endpoints != null) {this.endpoints.clear();}
            if (endpoints != null) {for (WorkloadEntrySpec item :endpoints){ this.addToEndpoints(item);}} return (A) this;
    }

    public Boolean hasEndpoints(){
            return endpoints != null && !endpoints.isEmpty();
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpoint(){
            return new EndpointsNestedImpl();
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpointLike(WorkloadEntrySpec item){
            return new EndpointsNestedImpl(-1, item);
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> setNewEndpointLike(int index,WorkloadEntrySpec item){
            return new EndpointsNestedImpl(index, item);
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> editEndpoint(int index){
            if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
            return setNewEndpointLike(index, buildEndpoint(index));
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> editFirstEndpoint(){
            if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
            return setNewEndpointLike(0, buildEndpoint(0));
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> editLastEndpoint(){
            int index = endpoints.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
            return setNewEndpointLike(index, buildEndpoint(index));
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> editMatchingEndpoint(io.fabric8.kubernetes.api.builder.Predicate<WorkloadEntrySpecBuilder> predicate){
            int index = -1;
            for (int i=0;i<endpoints.size();i++) { 
            if (predicate.apply(endpoints.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
            return setNewEndpointLike(index, buildEndpoint(index));
    }

    public A addToExportTo(int index,String item){
            if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
            this.exportTo.add(index, item);
            return (A)this;
    }

    public A setToExportTo(int index,String item){
            if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
            this.exportTo.set(index, item); return (A)this;
    }

    public A addToExportTo(String... items){
            if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
            for (String item : items) {this.exportTo.add(item);} return (A)this;
    }

    public A addAllToExportTo(Collection<String> items){
            if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
            for (String item : items) {this.exportTo.add(item);} return (A)this;
    }

    public A removeFromExportTo(String... items){
            for (String item : items) {if (this.exportTo!= null){ this.exportTo.remove(item);}} return (A)this;
    }

    public A removeAllFromExportTo(Collection<String> items){
            for (String item : items) {if (this.exportTo!= null){ this.exportTo.remove(item);}} return (A)this;
    }

    public List<String> getExportTo(){
            return this.exportTo;
    }

    public String getExportTo(int index){
            return this.exportTo.get(index);
    }

    public String getFirstExportTo(){
            return this.exportTo.get(0);
    }

    public String getLastExportTo(){
            return this.exportTo.get(exportTo.size() - 1);
    }

    public String getMatchingExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: exportTo) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: exportTo) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withExportTo(List<String> exportTo){
            if (this.exportTo != null) { _visitables.get("exportTo").removeAll(this.exportTo);}
            if (exportTo != null) {this.exportTo = new ArrayList<String>(); for (String item : exportTo){this.addToExportTo(item);}} else { this.exportTo = null;} return (A) this;
    }

    public A withExportTo(String... exportTo){
            if (this.exportTo != null) {this.exportTo.clear();}
            if (exportTo != null) {for (String item :exportTo){ this.addToExportTo(item);}} return (A) this;
    }

    public Boolean hasExportTo(){
            return exportTo != null && !exportTo.isEmpty();
    }

    public A addNewExportTo(String arg1){
            return (A)addToExportTo(new String(arg1));
    }

    public A addNewExportTo(StringBuilder arg1){
            return (A)addToExportTo(new String(arg1));
    }

    public A addNewExportTo(StringBuffer arg1){
            return (A)addToExportTo(new String(arg1));
    }

    public A addToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.add(index, item);
            return (A)this;
    }

    public A setToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.set(index, item); return (A)this;
    }

    public A addToHosts(String... items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A addAllToHosts(Collection<String> items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A removeFromHosts(String... items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public A removeAllFromHosts(Collection<String> items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public List<String> getHosts(){
            return this.hosts;
    }

    public String getHost(int index){
            return this.hosts.get(index);
    }

    public String getFirstHost(){
            return this.hosts.get(0);
    }

    public String getLastHost(){
            return this.hosts.get(hosts.size() - 1);
    }

    public String getMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withHosts(List<String> hosts){
            if (this.hosts != null) { _visitables.get("hosts").removeAll(this.hosts);}
            if (hosts != null) {this.hosts = new ArrayList<String>(); for (String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
    }

    public A withHosts(String... hosts){
            if (this.hosts != null) {this.hosts.clear();}
            if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
    }

    public Boolean hasHosts(){
            return hosts != null && !hosts.isEmpty();
    }

    public A addNewHost(String arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addNewHost(StringBuilder arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addNewHost(StringBuffer arg1){
            return (A)addToHosts(new String(arg1));
    }

    public ServiceEntryLocation getLocation(){
            return this.location;
    }

    public A withLocation(ServiceEntryLocation location){
            this.location=location; return (A) this;
    }

    public Boolean hasLocation(){
            return this.location != null;
    }

    public A addToPorts(int index,Port item){
            if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
            PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,Port item){
            if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
            PortBuilder builder = new PortBuilder(item);
            if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
            if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
             return (A)this;
    }

    public A addToPorts(Port... items){
            if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
            for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<Port> items){
            if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
            for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(Port... items){
            for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<Port> items){
            for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPorts(io.fabric8.kubernetes.api.builder.Predicate<PortBuilder> predicate){
            if (ports == null) return (A) this;
            final Iterator<PortBuilder> each = ports.iterator();
            final List visitables = _visitables.get("ports");
            while (each.hasNext()) {
              PortBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<Port> getPorts(){
            return build(ports);
    }

    public List<Port> buildPorts(){
            return build(ports);
    }

    public Port buildPort(int index){
            return this.ports.get(index).build();
    }

    public Port buildFirstPort(){
            return this.ports.get(0).build();
    }

    public Port buildLastPort(){
            return this.ports.get(ports.size() - 1).build();
    }

    public Port buildMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortBuilder> predicate){
            for (PortBuilder item: ports) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortBuilder> predicate){
            for (PortBuilder item: ports) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPorts(List<Port> ports){
            if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
            if (ports != null) {this.ports = new ArrayList<PortBuilder>(); for (Port item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(Port... ports){
            if (this.ports != null) {this.ports.clear();}
            if (ports != null) {for (Port item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts(){
            return ports != null && !ports.isEmpty();
    }

    public A addNewPort(String name,Integer number,String protocol,Integer targetPort){
            return (A)addToPorts(new Port(name, number, protocol, targetPort));
    }

    public ServiceEntrySpecFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public ServiceEntrySpecFluent.PortsNested<A> addNewPortLike(Port item){
            return new PortsNestedImpl(-1, item);
    }

    public ServiceEntrySpecFluent.PortsNested<A> setNewPortLike(int index,Port item){
            return new PortsNestedImpl(index, item);
    }

    public ServiceEntrySpecFluent.PortsNested<A> editPort(int index){
            if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
            return setNewPortLike(index, buildPort(index));
    }

    public ServiceEntrySpecFluent.PortsNested<A> editFirstPort(){
            if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
            return setNewPortLike(0, buildPort(0));
    }

    public ServiceEntrySpecFluent.PortsNested<A> editLastPort(){
            int index = ports.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
            return setNewPortLike(index, buildPort(index));
    }

    public ServiceEntrySpecFluent.PortsNested<A> editMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortBuilder> predicate){
            int index = -1;
            for (int i=0;i<ports.size();i++) { 
            if (predicate.apply(ports.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
            return setNewPortLike(index, buildPort(index));
    }

    public ServiceEntryResolution getResolution(){
            return this.resolution;
    }

    public A withResolution(ServiceEntryResolution resolution){
            this.resolution=resolution; return (A) this;
    }

    public Boolean hasResolution(){
            return this.resolution != null;
    }

    public A addToSubjectAltNames(int index,String item){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            this.subjectAltNames.add(index, item);
            return (A)this;
    }

    public A setToSubjectAltNames(int index,String item){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            this.subjectAltNames.set(index, item); return (A)this;
    }

    public A addToSubjectAltNames(String... items){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
    }

    public A addAllToSubjectAltNames(Collection<String> items){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
    }

    public A removeFromSubjectAltNames(String... items){
            for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
    }

    public A removeAllFromSubjectAltNames(Collection<String> items){
            for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
    }

    public List<String> getSubjectAltNames(){
            return this.subjectAltNames;
    }

    public String getSubjectAltName(int index){
            return this.subjectAltNames.get(index);
    }

    public String getFirstSubjectAltName(){
            return this.subjectAltNames.get(0);
    }

    public String getLastSubjectAltName(){
            return this.subjectAltNames.get(subjectAltNames.size() - 1);
    }

    public String getMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: subjectAltNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: subjectAltNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSubjectAltNames(List<String> subjectAltNames){
            if (this.subjectAltNames != null) { _visitables.get("subjectAltNames").removeAll(this.subjectAltNames);}
            if (subjectAltNames != null) {this.subjectAltNames = new ArrayList<String>(); for (String item : subjectAltNames){this.addToSubjectAltNames(item);}} else { this.subjectAltNames = null;} return (A) this;
    }

    public A withSubjectAltNames(String... subjectAltNames){
            if (this.subjectAltNames != null) {this.subjectAltNames.clear();}
            if (subjectAltNames != null) {for (String item :subjectAltNames){ this.addToSubjectAltNames(item);}} return (A) this;
    }

    public Boolean hasSubjectAltNames(){
            return subjectAltNames != null && !subjectAltNames.isEmpty();
    }

    public A addNewSubjectAltName(String arg1){
            return (A)addToSubjectAltNames(new String(arg1));
    }

    public A addNewSubjectAltName(StringBuilder arg1){
            return (A)addToSubjectAltNames(new String(arg1));
    }

    public A addNewSubjectAltName(StringBuffer arg1){
            return (A)addToSubjectAltNames(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildWorkloadSelector instead.
 * @return The buildable object.
 */
@Deprecated public WorkloadSelector getWorkloadSelector(){
            return this.workloadSelector!=null?this.workloadSelector.build():null;
    }

    public WorkloadSelector buildWorkloadSelector(){
            return this.workloadSelector!=null?this.workloadSelector.build():null;
    }

    public A withWorkloadSelector(WorkloadSelector workloadSelector){
            _visitables.get("workloadSelector").remove(this.workloadSelector);
            if (workloadSelector!=null){ this.workloadSelector= new WorkloadSelectorBuilder(workloadSelector); _visitables.get("workloadSelector").add(this.workloadSelector);} return (A) this;
    }

    public Boolean hasWorkloadSelector(){
            return this.workloadSelector != null;
    }

    public ServiceEntrySpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector(){
            return new WorkloadSelectorNestedImpl();
    }

    public ServiceEntrySpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item){
            return new WorkloadSelectorNestedImpl(item);
    }

    public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editWorkloadSelector(){
            return withNewWorkloadSelectorLike(getWorkloadSelector());
    }

    public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector(){
            return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): new WorkloadSelectorBuilder().build());
    }

    public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item){
            return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ServiceEntrySpecFluentImpl that = (ServiceEntrySpecFluentImpl) o;
            if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
            if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
            if (exportTo != null ? !exportTo.equals(that.exportTo) :that.exportTo != null) return false;
            if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
            if (location != null ? !location.equals(that.location) :that.location != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            if (resolution != null ? !resolution.equals(that.resolution) :that.resolution != null) return false;
            if (subjectAltNames != null ? !subjectAltNames.equals(that.subjectAltNames) :that.subjectAltNames != null) return false;
            if (workloadSelector != null ? !workloadSelector.equals(that.workloadSelector) :that.workloadSelector != null) return false;
            return true;
    }


    public class EndpointsNestedImpl<N> extends WorkloadEntrySpecFluentImpl<ServiceEntrySpecFluent.EndpointsNested<N>> implements ServiceEntrySpecFluent.EndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final WorkloadEntrySpecBuilder builder;
        private final int index;
    
            EndpointsNestedImpl(int index,WorkloadEntrySpec item){
                    this.index = index;
                    this.builder = new WorkloadEntrySpecBuilder(this, item);
            }
            EndpointsNestedImpl(){
                    this.index = -1;
                    this.builder = new WorkloadEntrySpecBuilder(this);
            }
    
    public N and(){
            return (N) ServiceEntrySpecFluentImpl.this.setToEndpoints(index,builder.build());
    }
    public N endEndpoint(){
            return and();
    }

}
    public class PortsNestedImpl<N> extends PortFluentImpl<ServiceEntrySpecFluent.PortsNested<N>> implements ServiceEntrySpecFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PortBuilder builder;
        private final int index;
    
            PortsNestedImpl(int index,Port item){
                    this.index = index;
                    this.builder = new PortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.index = -1;
                    this.builder = new PortBuilder(this);
            }
    
    public N and(){
            return (N) ServiceEntrySpecFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort(){
            return and();
    }

}
    public class WorkloadSelectorNestedImpl<N> extends WorkloadSelectorFluentImpl<ServiceEntrySpecFluent.WorkloadSelectorNested<N>> implements ServiceEntrySpecFluent.WorkloadSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final WorkloadSelectorBuilder builder;
    
            WorkloadSelectorNestedImpl(WorkloadSelector item){
                    this.builder = new WorkloadSelectorBuilder(this, item);
            }
            WorkloadSelectorNestedImpl(){
                    this.builder = new WorkloadSelectorBuilder(this);
            }
    
    public N and(){
            return (N) ServiceEntrySpecFluentImpl.this.withWorkloadSelector(builder.build());
    }
    public N endWorkloadSelector(){
            return and();
    }

}


}
