package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SidecarListBuilder extends SidecarListFluentImpl<SidecarListBuilder> implements VisitableBuilder<SidecarList,SidecarListBuilder>{

    SidecarListFluent<?> fluent;
    Boolean validationEnabled;

    public SidecarListBuilder(){
            this(true);
    }
    public SidecarListBuilder(Boolean validationEnabled){
            this(new SidecarList(), validationEnabled);
    }
    public SidecarListBuilder(SidecarListFluent<?> fluent){
            this(fluent, true);
    }
    public SidecarListBuilder(SidecarListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SidecarList(), validationEnabled);
    }
    public SidecarListBuilder(SidecarListFluent<?> fluent,SidecarList instance){
            this(fluent, instance, true);
    }
    public SidecarListBuilder(SidecarListFluent<?> fluent,SidecarList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public SidecarListBuilder(SidecarList instance){
            this(instance,true);
    }
    public SidecarListBuilder(SidecarList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public SidecarList build(){
            SidecarList buildable = new SidecarList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SidecarListBuilder that = (SidecarListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
