package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SidecarSpecBuilder extends SidecarSpecFluentImpl<SidecarSpecBuilder> implements VisitableBuilder<SidecarSpec,SidecarSpecBuilder>{

    SidecarSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SidecarSpecBuilder(){
            this(true);
    }
    public SidecarSpecBuilder(Boolean validationEnabled){
            this(new SidecarSpec(), validationEnabled);
    }
    public SidecarSpecBuilder(SidecarSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SidecarSpecBuilder(SidecarSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SidecarSpec(), validationEnabled);
    }
    public SidecarSpecBuilder(SidecarSpecFluent<?> fluent,SidecarSpec instance){
            this(fluent, instance, true);
    }
    public SidecarSpecBuilder(SidecarSpecFluent<?> fluent,SidecarSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEgress(instance.getEgress()); 
            fluent.withIngress(instance.getIngress()); 
            fluent.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            fluent.withWorkloadSelector(instance.getWorkloadSelector()); 
            this.validationEnabled = validationEnabled; 
    }
    public SidecarSpecBuilder(SidecarSpec instance){
            this(instance,true);
    }
    public SidecarSpecBuilder(SidecarSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEgress(instance.getEgress()); 
            this.withIngress(instance.getIngress()); 
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            this.withWorkloadSelector(instance.getWorkloadSelector()); 
            this.validationEnabled = validationEnabled; 
    }

    public SidecarSpec build(){
            SidecarSpec buildable = new SidecarSpec(fluent.getEgress(),fluent.getIngress(),fluent.getOutboundTrafficPolicy(),fluent.getWorkloadSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SidecarSpecBuilder that = (SidecarSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
