package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class SidecarSpecFluentImpl<A extends SidecarSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SidecarSpecFluent<A>{

    private List<IstioEgressListenerBuilder> egress;
    private List<IstioIngressListenerBuilder> ingress;
    private me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicyBuilder outboundTrafficPolicy;
    private WorkloadSelectorBuilder workloadSelector;

    public SidecarSpecFluentImpl(){
    }
    public SidecarSpecFluentImpl(SidecarSpec instance){
            this.withEgress(instance.getEgress()); 
            this.withIngress(instance.getIngress()); 
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            this.withWorkloadSelector(instance.getWorkloadSelector()); 
    }

    public A addToEgress(int index,IstioEgressListener item){
            if (this.egress == null) {this.egress = new ArrayList<IstioEgressListenerBuilder>();}
            IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);_visitables.get("egress").add(index >= 0 ? index : _visitables.get("egress").size(), builder);this.egress.add(index >= 0 ? index : egress.size(), builder); return (A)this;
    }

    public A setToEgress(int index,IstioEgressListener item){
            if (this.egress == null) {this.egress = new ArrayList<IstioEgressListenerBuilder>();}
            IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
            if (index < 0 || index >= _visitables.get("egress").size()) { _visitables.get("egress").add(builder); } else { _visitables.get("egress").set(index, builder);}
            if (index < 0 || index >= egress.size()) { egress.add(builder); } else { egress.set(index, builder);}
             return (A)this;
    }

    public A addToEgress(IstioEgressListener... items){
            if (this.egress == null) {this.egress = new ArrayList<IstioEgressListenerBuilder>();}
            for (IstioEgressListener item : items) {IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
    }

    public A addAllToEgress(Collection<IstioEgressListener> items){
            if (this.egress == null) {this.egress = new ArrayList<IstioEgressListenerBuilder>();}
            for (IstioEgressListener item : items) {IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
    }

    public A removeFromEgress(IstioEgressListener... items){
            for (IstioEgressListener item : items) {IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
    }

    public A removeAllFromEgress(Collection<IstioEgressListener> items){
            for (IstioEgressListener item : items) {IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEgress(io.fabric8.kubernetes.api.builder.Predicate<IstioEgressListenerBuilder> predicate){
            if (egress == null) return (A) this;
            final Iterator<IstioEgressListenerBuilder> each = egress.iterator();
            final List visitables = _visitables.get("egress");
            while (each.hasNext()) {
              IstioEgressListenerBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEgress instead.
 * @return The buildable object.
 */
@Deprecated public List<IstioEgressListener> getEgress(){
            return build(egress);
    }

    public List<IstioEgressListener> buildEgress(){
            return build(egress);
    }

    public IstioEgressListener buildEgress(int index){
            return this.egress.get(index).build();
    }

    public IstioEgressListener buildFirstEgress(){
            return this.egress.get(0).build();
    }

    public IstioEgressListener buildLastEgress(){
            return this.egress.get(egress.size() - 1).build();
    }

    public IstioEgressListener buildMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<IstioEgressListenerBuilder> predicate){
            for (IstioEgressListenerBuilder item: egress) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<IstioEgressListenerBuilder> predicate){
            for (IstioEgressListenerBuilder item: egress) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEgress(List<IstioEgressListener> egress){
            if (this.egress != null) { _visitables.get("egress").removeAll(this.egress);}
            if (egress != null) {this.egress = new ArrayList<IstioEgressListenerBuilder>(); for (IstioEgressListener item : egress){this.addToEgress(item);}} else { this.egress = null;} return (A) this;
    }

    public A withEgress(IstioEgressListener... egress){
            if (this.egress != null) {this.egress.clear();}
            if (egress != null) {for (IstioEgressListener item :egress){ this.addToEgress(item);}} return (A) this;
    }

    public Boolean hasEgress(){
            return egress != null && !egress.isEmpty();
    }

    public SidecarSpecFluent.EgressNested<A> addNewEgress(){
            return new EgressNestedImpl();
    }

    public SidecarSpecFluent.EgressNested<A> addNewEgressLike(IstioEgressListener item){
            return new EgressNestedImpl(-1, item);
    }

    public SidecarSpecFluent.EgressNested<A> setNewEgressLike(int index,IstioEgressListener item){
            return new EgressNestedImpl(index, item);
    }

    public SidecarSpecFluent.EgressNested<A> editEgress(int index){
            if (egress.size() <= index) throw new RuntimeException("Can't edit egress. Index exceeds size.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public SidecarSpecFluent.EgressNested<A> editFirstEgress(){
            if (egress.size() == 0) throw new RuntimeException("Can't edit first egress. The list is empty.");
            return setNewEgressLike(0, buildEgress(0));
    }

    public SidecarSpecFluent.EgressNested<A> editLastEgress(){
            int index = egress.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last egress. The list is empty.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public SidecarSpecFluent.EgressNested<A> editMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<IstioEgressListenerBuilder> predicate){
            int index = -1;
            for (int i=0;i<egress.size();i++) { 
            if (predicate.apply(egress.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching egress. No match found.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public A addToIngress(int index,IstioIngressListener item){
            if (this.ingress == null) {this.ingress = new ArrayList<IstioIngressListenerBuilder>();}
            IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);_visitables.get("ingress").add(index >= 0 ? index : _visitables.get("ingress").size(), builder);this.ingress.add(index >= 0 ? index : ingress.size(), builder); return (A)this;
    }

    public A setToIngress(int index,IstioIngressListener item){
            if (this.ingress == null) {this.ingress = new ArrayList<IstioIngressListenerBuilder>();}
            IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
            if (index < 0 || index >= _visitables.get("ingress").size()) { _visitables.get("ingress").add(builder); } else { _visitables.get("ingress").set(index, builder);}
            if (index < 0 || index >= ingress.size()) { ingress.add(builder); } else { ingress.set(index, builder);}
             return (A)this;
    }

    public A addToIngress(IstioIngressListener... items){
            if (this.ingress == null) {this.ingress = new ArrayList<IstioIngressListenerBuilder>();}
            for (IstioIngressListener item : items) {IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A addAllToIngress(Collection<IstioIngressListener> items){
            if (this.ingress == null) {this.ingress = new ArrayList<IstioIngressListenerBuilder>();}
            for (IstioIngressListener item : items) {IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A removeFromIngress(IstioIngressListener... items){
            for (IstioIngressListener item : items) {IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
    }

    public A removeAllFromIngress(Collection<IstioIngressListener> items){
            for (IstioIngressListener item : items) {IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIngress(io.fabric8.kubernetes.api.builder.Predicate<IstioIngressListenerBuilder> predicate){
            if (ingress == null) return (A) this;
            final Iterator<IstioIngressListenerBuilder> each = ingress.iterator();
            final List visitables = _visitables.get("ingress");
            while (each.hasNext()) {
              IstioIngressListenerBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIngress instead.
 * @return The buildable object.
 */
@Deprecated public List<IstioIngressListener> getIngress(){
            return build(ingress);
    }

    public List<IstioIngressListener> buildIngress(){
            return build(ingress);
    }

    public IstioIngressListener buildIngress(int index){
            return this.ingress.get(index).build();
    }

    public IstioIngressListener buildFirstIngress(){
            return this.ingress.get(0).build();
    }

    public IstioIngressListener buildLastIngress(){
            return this.ingress.get(ingress.size() - 1).build();
    }

    public IstioIngressListener buildMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<IstioIngressListenerBuilder> predicate){
            for (IstioIngressListenerBuilder item: ingress) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<IstioIngressListenerBuilder> predicate){
            for (IstioIngressListenerBuilder item: ingress) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withIngress(List<IstioIngressListener> ingress){
            if (this.ingress != null) { _visitables.get("ingress").removeAll(this.ingress);}
            if (ingress != null) {this.ingress = new ArrayList<IstioIngressListenerBuilder>(); for (IstioIngressListener item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
    }

    public A withIngress(IstioIngressListener... ingress){
            if (this.ingress != null) {this.ingress.clear();}
            if (ingress != null) {for (IstioIngressListener item :ingress){ this.addToIngress(item);}} return (A) this;
    }

    public Boolean hasIngress(){
            return ingress != null && !ingress.isEmpty();
    }

    public SidecarSpecFluent.IngressNested<A> addNewIngress(){
            return new IngressNestedImpl();
    }

    public SidecarSpecFluent.IngressNested<A> addNewIngressLike(IstioIngressListener item){
            return new IngressNestedImpl(-1, item);
    }

    public SidecarSpecFluent.IngressNested<A> setNewIngressLike(int index,IstioIngressListener item){
            return new IngressNestedImpl(index, item);
    }

    public SidecarSpecFluent.IngressNested<A> editIngress(int index){
            if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public SidecarSpecFluent.IngressNested<A> editFirstIngress(){
            if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
            return setNewIngressLike(0, buildIngress(0));
    }

    public SidecarSpecFluent.IngressNested<A> editLastIngress(){
            int index = ingress.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public SidecarSpecFluent.IngressNested<A> editMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<IstioIngressListenerBuilder> predicate){
            int index = -1;
            for (int i=0;i<ingress.size();i++) { 
            if (predicate.apply(ingress.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
            return setNewIngressLike(index, buildIngress(index));
    }

    
/**
 * This method has been deprecated, please use method buildOutboundTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicy getOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy!=null?this.outboundTrafficPolicy.build():null;
    }

    public me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicy buildOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy!=null?this.outboundTrafficPolicy.build():null;
    }

    public A withOutboundTrafficPolicy(me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicy outboundTrafficPolicy){
            _visitables.get("outboundTrafficPolicy").remove(this.outboundTrafficPolicy);
            if (outboundTrafficPolicy!=null){ this.outboundTrafficPolicy= new me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicyBuilder(outboundTrafficPolicy); _visitables.get("outboundTrafficPolicy").add(this.outboundTrafficPolicy);} return (A) this;
    }

    public Boolean hasOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy != null;
    }

    public SidecarSpecFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicy(){
            return new OutboundTrafficPolicyNestedImpl();
    }

    public SidecarSpecFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicyLike(me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicy item){
            return new OutboundTrafficPolicyNestedImpl(item);
    }

    public SidecarSpecFluent.OutboundTrafficPolicyNested<A> editOutboundTrafficPolicy(){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy());
    }

    public SidecarSpecFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicy(){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): new me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicyBuilder().build());
    }

    public SidecarSpecFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicyLike(me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicy item){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildWorkloadSelector instead.
 * @return The buildable object.
 */
@Deprecated public WorkloadSelector getWorkloadSelector(){
            return this.workloadSelector!=null?this.workloadSelector.build():null;
    }

    public WorkloadSelector buildWorkloadSelector(){
            return this.workloadSelector!=null?this.workloadSelector.build():null;
    }

    public A withWorkloadSelector(WorkloadSelector workloadSelector){
            _visitables.get("workloadSelector").remove(this.workloadSelector);
            if (workloadSelector!=null){ this.workloadSelector= new WorkloadSelectorBuilder(workloadSelector); _visitables.get("workloadSelector").add(this.workloadSelector);} return (A) this;
    }

    public Boolean hasWorkloadSelector(){
            return this.workloadSelector != null;
    }

    public SidecarSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector(){
            return new WorkloadSelectorNestedImpl();
    }

    public SidecarSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item){
            return new WorkloadSelectorNestedImpl(item);
    }

    public SidecarSpecFluent.WorkloadSelectorNested<A> editWorkloadSelector(){
            return withNewWorkloadSelectorLike(getWorkloadSelector());
    }

    public SidecarSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector(){
            return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): new WorkloadSelectorBuilder().build());
    }

    public SidecarSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item){
            return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SidecarSpecFluentImpl that = (SidecarSpecFluentImpl) o;
            if (egress != null ? !egress.equals(that.egress) :that.egress != null) return false;
            if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
            if (outboundTrafficPolicy != null ? !outboundTrafficPolicy.equals(that.outboundTrafficPolicy) :that.outboundTrafficPolicy != null) return false;
            if (workloadSelector != null ? !workloadSelector.equals(that.workloadSelector) :that.workloadSelector != null) return false;
            return true;
    }


    public class EgressNestedImpl<N> extends IstioEgressListenerFluentImpl<SidecarSpecFluent.EgressNested<N>> implements SidecarSpecFluent.EgressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IstioEgressListenerBuilder builder;
        private final int index;
    
            EgressNestedImpl(int index,IstioEgressListener item){
                    this.index = index;
                    this.builder = new IstioEgressListenerBuilder(this, item);
            }
            EgressNestedImpl(){
                    this.index = -1;
                    this.builder = new IstioEgressListenerBuilder(this);
            }
    
    public N and(){
            return (N) SidecarSpecFluentImpl.this.setToEgress(index,builder.build());
    }
    public N endEgress(){
            return and();
    }

}
    public class IngressNestedImpl<N> extends IstioIngressListenerFluentImpl<SidecarSpecFluent.IngressNested<N>> implements SidecarSpecFluent.IngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IstioIngressListenerBuilder builder;
        private final int index;
    
            IngressNestedImpl(int index,IstioIngressListener item){
                    this.index = index;
                    this.builder = new IstioIngressListenerBuilder(this, item);
            }
            IngressNestedImpl(){
                    this.index = -1;
                    this.builder = new IstioIngressListenerBuilder(this);
            }
    
    public N and(){
            return (N) SidecarSpecFluentImpl.this.setToIngress(index,builder.build());
    }
    public N endIngress(){
            return and();
    }

}
    public class OutboundTrafficPolicyNestedImpl<N> extends me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicyFluentImpl<SidecarSpecFluent.OutboundTrafficPolicyNested<N>> implements SidecarSpecFluent.OutboundTrafficPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicyBuilder builder;
    
            OutboundTrafficPolicyNestedImpl(me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicy item){
                    this.builder = new me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicyBuilder(this, item);
            }
            OutboundTrafficPolicyNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1alpha3.OutboundTrafficPolicyBuilder(this);
            }
    
    public N and(){
            return (N) SidecarSpecFluentImpl.this.withOutboundTrafficPolicy(builder.build());
    }
    public N endOutboundTrafficPolicy(){
            return and();
    }

}
    public class WorkloadSelectorNestedImpl<N> extends WorkloadSelectorFluentImpl<SidecarSpecFluent.WorkloadSelectorNested<N>> implements SidecarSpecFluent.WorkloadSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final WorkloadSelectorBuilder builder;
    
            WorkloadSelectorNestedImpl(WorkloadSelector item){
                    this.builder = new WorkloadSelectorBuilder(this, item);
            }
            WorkloadSelectorNestedImpl(){
                    this.builder = new WorkloadSelectorBuilder(this);
            }
    
    public N and(){
            return (N) SidecarSpecFluentImpl.this.withWorkloadSelector(builder.build());
    }
    public N endWorkloadSelector(){
            return and();
    }

}


}
