package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;
import java.lang.Object;

public class StringMatchFluentImpl<A extends StringMatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StringMatchFluent<A>{

    private VisitableBuilder<? extends StringMatch.MatchType,?> matchType;

    public StringMatchFluentImpl(){
    }
    public StringMatchFluentImpl(StringMatch instance){
            this.withMatchType(instance.getMatchType()); 
    }

    
/**
 * This method has been deprecated, please use method buildMatchType instead.
 * @return The buildable object.
 */
@Deprecated public StringMatch.MatchType getMatchType(){
            return this.matchType!=null?this.matchType.build():null;
    }

    public StringMatch.MatchType buildMatchType(){
            return this.matchType!=null?this.matchType.build():null;
    }

    public A withMatchType(StringMatch.MatchType matchType){
            if (matchType instanceof RegexMatchType){ this.matchType= new RegexMatchTypeBuilder((RegexMatchType)matchType); _visitables.get("matchType").add(this.matchType);}
            if (matchType instanceof PrefixMatchType){ this.matchType= new PrefixMatchTypeBuilder((PrefixMatchType)matchType); _visitables.get("matchType").add(this.matchType);}
            if (matchType instanceof ExactMatchType){ this.matchType= new ExactMatchTypeBuilder((ExactMatchType)matchType); _visitables.get("matchType").add(this.matchType);}
            return (A) this;
    }

    public Boolean hasMatchType(){
            return this.matchType != null;
    }

    public A withRegexMatchType(RegexMatchType regexMatchType){
            _visitables.get("matchType").remove(this.matchType);
            if (regexMatchType!=null){ this.matchType= new RegexMatchTypeBuilder(regexMatchType); _visitables.get("matchType").add(this.matchType);} return (A) this;
    }

    public StringMatchFluent.RegexMatchTypeNested<A> withNewRegexMatchType(){
            return new RegexMatchTypeNestedImpl();
    }

    public StringMatchFluent.RegexMatchTypeNested<A> withNewRegexMatchTypeLike(RegexMatchType item){
            return new RegexMatchTypeNestedImpl(item);
    }

    public A withNewRegexMatchType(String regex){
            return (A)withRegexMatchType(new RegexMatchType(regex));
    }

    public A withPrefixMatchType(PrefixMatchType prefixMatchType){
            _visitables.get("matchType").remove(this.matchType);
            if (prefixMatchType!=null){ this.matchType= new PrefixMatchTypeBuilder(prefixMatchType); _visitables.get("matchType").add(this.matchType);} return (A) this;
    }

    public StringMatchFluent.PrefixMatchTypeNested<A> withNewPrefixMatchType(){
            return new PrefixMatchTypeNestedImpl();
    }

    public StringMatchFluent.PrefixMatchTypeNested<A> withNewPrefixMatchTypeLike(PrefixMatchType item){
            return new PrefixMatchTypeNestedImpl(item);
    }

    public A withNewPrefixMatchType(String prefix){
            return (A)withPrefixMatchType(new PrefixMatchType(prefix));
    }

    public A withExactMatchType(ExactMatchType exactMatchType){
            _visitables.get("matchType").remove(this.matchType);
            if (exactMatchType!=null){ this.matchType= new ExactMatchTypeBuilder(exactMatchType); _visitables.get("matchType").add(this.matchType);} return (A) this;
    }

    public StringMatchFluent.ExactMatchTypeNested<A> withNewExactMatchType(){
            return new ExactMatchTypeNestedImpl();
    }

    public StringMatchFluent.ExactMatchTypeNested<A> withNewExactMatchTypeLike(ExactMatchType item){
            return new ExactMatchTypeNestedImpl(item);
    }

    public A withNewExactMatchType(String exact){
            return (A)withExactMatchType(new ExactMatchType(exact));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            StringMatchFluentImpl that = (StringMatchFluentImpl) o;
            if (matchType != null ? !matchType.equals(that.matchType) :that.matchType != null) return false;
            return true;
    }


    public class RegexMatchTypeNestedImpl<N> extends RegexMatchTypeFluentImpl<StringMatchFluent.RegexMatchTypeNested<N>> implements StringMatchFluent.RegexMatchTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RegexMatchTypeBuilder builder;
    
            RegexMatchTypeNestedImpl(RegexMatchType item){
                    this.builder = new RegexMatchTypeBuilder(this, item);
            }
            RegexMatchTypeNestedImpl(){
                    this.builder = new RegexMatchTypeBuilder(this);
            }
    
    public N and(){
            return (N) StringMatchFluentImpl.this.withMatchType(builder.build());
    }
    public N endRegexMatchType(){
            return and();
    }

}
    public class PrefixMatchTypeNestedImpl<N> extends PrefixMatchTypeFluentImpl<StringMatchFluent.PrefixMatchTypeNested<N>> implements StringMatchFluent.PrefixMatchTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PrefixMatchTypeBuilder builder;
    
            PrefixMatchTypeNestedImpl(PrefixMatchType item){
                    this.builder = new PrefixMatchTypeBuilder(this, item);
            }
            PrefixMatchTypeNestedImpl(){
                    this.builder = new PrefixMatchTypeBuilder(this);
            }
    
    public N and(){
            return (N) StringMatchFluentImpl.this.withMatchType(builder.build());
    }
    public N endPrefixMatchType(){
            return and();
    }

}
    public class ExactMatchTypeNestedImpl<N> extends ExactMatchTypeFluentImpl<StringMatchFluent.ExactMatchTypeNested<N>> implements StringMatchFluent.ExactMatchTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ExactMatchTypeBuilder builder;
    
            ExactMatchTypeNestedImpl(ExactMatchType item){
                    this.builder = new ExactMatchTypeBuilder(this, item);
            }
            ExactMatchTypeNestedImpl(){
                    this.builder = new ExactMatchTypeBuilder(this);
            }
    
    public N and(){
            return (N) StringMatchFluentImpl.this.withMatchType(builder.build());
    }
    public N endExactMatchType(){
            return and();
    }

}


}
