package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubFilterMatchBuilder extends SubFilterMatchFluentImpl<SubFilterMatchBuilder> implements VisitableBuilder<SubFilterMatch,SubFilterMatchBuilder>{

    SubFilterMatchFluent<?> fluent;
    Boolean validationEnabled;

    public SubFilterMatchBuilder(){
            this(true);
    }
    public SubFilterMatchBuilder(Boolean validationEnabled){
            this(new SubFilterMatch(), validationEnabled);
    }
    public SubFilterMatchBuilder(SubFilterMatchFluent<?> fluent){
            this(fluent, true);
    }
    public SubFilterMatchBuilder(SubFilterMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubFilterMatch(), validationEnabled);
    }
    public SubFilterMatchBuilder(SubFilterMatchFluent<?> fluent,SubFilterMatch instance){
            this(fluent, instance, true);
    }
    public SubFilterMatchBuilder(SubFilterMatchFluent<?> fluent,SubFilterMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubFilterMatchBuilder(SubFilterMatch instance){
            this(instance,true);
    }
    public SubFilterMatchBuilder(SubFilterMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubFilterMatch build(){
            SubFilterMatch buildable = new SubFilterMatch(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubFilterMatchBuilder that = (SubFilterMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
