package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class SubsetFluentImpl<A extends SubsetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubsetFluent<A>{

    private Map<String,String> labels;
    private String name;
    private TrafficPolicyBuilder trafficPolicy;

    public SubsetFluentImpl(){
    }
    public SubsetFluentImpl(Subset instance){
            this.withLabels(instance.getLabels()); 
            this.withName(instance.getName()); 
            this.withTrafficPolicy(instance.getTrafficPolicy()); 
    }

    public A addToLabels(String key,String value){
            if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(this.labels == null && map != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(this.labels == null) { return (A) this; }
            if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(this.labels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.labels;
    }

    public A withLabels(Map<String,String> labels){
            if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap<String,String>(labels);} return (A) this;
    }

    public Boolean hasLabels(){
            return this.labels != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public TrafficPolicy getTrafficPolicy(){
            return this.trafficPolicy!=null?this.trafficPolicy.build():null;
    }

    public TrafficPolicy buildTrafficPolicy(){
            return this.trafficPolicy!=null?this.trafficPolicy.build():null;
    }

    public A withTrafficPolicy(TrafficPolicy trafficPolicy){
            _visitables.get("trafficPolicy").remove(this.trafficPolicy);
            if (trafficPolicy!=null){ this.trafficPolicy= new TrafficPolicyBuilder(trafficPolicy); _visitables.get("trafficPolicy").add(this.trafficPolicy);} return (A) this;
    }

    public Boolean hasTrafficPolicy(){
            return this.trafficPolicy != null;
    }

    public SubsetFluent.TrafficPolicyNested<A> withNewTrafficPolicy(){
            return new TrafficPolicyNestedImpl();
    }

    public SubsetFluent.TrafficPolicyNested<A> withNewTrafficPolicyLike(TrafficPolicy item){
            return new TrafficPolicyNestedImpl(item);
    }

    public SubsetFluent.TrafficPolicyNested<A> editTrafficPolicy(){
            return withNewTrafficPolicyLike(getTrafficPolicy());
    }

    public SubsetFluent.TrafficPolicyNested<A> editOrNewTrafficPolicy(){
            return withNewTrafficPolicyLike(getTrafficPolicy() != null ? getTrafficPolicy(): new TrafficPolicyBuilder().build());
    }

    public SubsetFluent.TrafficPolicyNested<A> editOrNewTrafficPolicyLike(TrafficPolicy item){
            return withNewTrafficPolicyLike(getTrafficPolicy() != null ? getTrafficPolicy(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SubsetFluentImpl that = (SubsetFluentImpl) o;
            if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (trafficPolicy != null ? !trafficPolicy.equals(that.trafficPolicy) :that.trafficPolicy != null) return false;
            return true;
    }


    public class TrafficPolicyNestedImpl<N> extends TrafficPolicyFluentImpl<SubsetFluent.TrafficPolicyNested<N>> implements SubsetFluent.TrafficPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TrafficPolicyBuilder builder;
    
            TrafficPolicyNestedImpl(TrafficPolicy item){
                    this.builder = new TrafficPolicyBuilder(this, item);
            }
            TrafficPolicyNestedImpl(){
                    this.builder = new TrafficPolicyBuilder(this);
            }
    
    public N and(){
            return (N) SubsetFluentImpl.this.withTrafficPolicy(builder.build());
    }
    public N endTrafficPolicy(){
            return and();
    }

}


}
