package me.snowdrop.istio.api.networking.v1alpha3;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class TCPSettingsFluentImpl<A extends TCPSettingsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TCPSettingsFluent<A>{

    private DurationBuilder connectTimeout;
    private Integer maxConnections;
    private TcpKeepaliveBuilder tcpKeepalive;

    public TCPSettingsFluentImpl(){
    }
    public TCPSettingsFluentImpl(TCPSettings instance){
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withMaxConnections(instance.getMaxConnections()); 
            this.withTcpKeepalive(instance.getTcpKeepalive()); 
    }

    
/**
 * This method has been deprecated, please use method buildConnectTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public Duration buildConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public A withConnectTimeout(Duration connectTimeout){
            _visitables.get("connectTimeout").remove(this.connectTimeout);
            if (connectTimeout!=null){ this.connectTimeout= new DurationBuilder(connectTimeout); _visitables.get("connectTimeout").add(this.connectTimeout);} return (A) this;
    }

    public Boolean hasConnectTimeout(){
            return this.connectTimeout != null;
    }

    public A withNewConnectTimeout(Integer nanos,Long seconds){
            return (A)withConnectTimeout(new Duration(nanos, seconds));
    }

    public TCPSettingsFluent.ConnectTimeoutNested<A> withNewConnectTimeout(){
            return new ConnectTimeoutNestedImpl();
    }

    public TCPSettingsFluent.ConnectTimeoutNested<A> withNewConnectTimeoutLike(Duration item){
            return new ConnectTimeoutNestedImpl(item);
    }

    public TCPSettingsFluent.ConnectTimeoutNested<A> editConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout());
    }

    public TCPSettingsFluent.ConnectTimeoutNested<A> editOrNewConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): new DurationBuilder().build());
    }

    public TCPSettingsFluent.ConnectTimeoutNested<A> editOrNewConnectTimeoutLike(Duration item){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): item);
    }

    public Integer getMaxConnections(){
            return this.maxConnections;
    }

    public A withMaxConnections(Integer maxConnections){
            this.maxConnections=maxConnections; return (A) this;
    }

    public Boolean hasMaxConnections(){
            return this.maxConnections != null;
    }

    
/**
 * This method has been deprecated, please use method buildTcpKeepalive instead.
 * @return The buildable object.
 */
@Deprecated public TcpKeepalive getTcpKeepalive(){
            return this.tcpKeepalive!=null?this.tcpKeepalive.build():null;
    }

    public TcpKeepalive buildTcpKeepalive(){
            return this.tcpKeepalive!=null?this.tcpKeepalive.build():null;
    }

    public A withTcpKeepalive(TcpKeepalive tcpKeepalive){
            _visitables.get("tcpKeepalive").remove(this.tcpKeepalive);
            if (tcpKeepalive!=null){ this.tcpKeepalive= new TcpKeepaliveBuilder(tcpKeepalive); _visitables.get("tcpKeepalive").add(this.tcpKeepalive);} return (A) this;
    }

    public Boolean hasTcpKeepalive(){
            return this.tcpKeepalive != null;
    }

    public TCPSettingsFluent.TcpKeepaliveNested<A> withNewTcpKeepalive(){
            return new TcpKeepaliveNestedImpl();
    }

    public TCPSettingsFluent.TcpKeepaliveNested<A> withNewTcpKeepaliveLike(TcpKeepalive item){
            return new TcpKeepaliveNestedImpl(item);
    }

    public TCPSettingsFluent.TcpKeepaliveNested<A> editTcpKeepalive(){
            return withNewTcpKeepaliveLike(getTcpKeepalive());
    }

    public TCPSettingsFluent.TcpKeepaliveNested<A> editOrNewTcpKeepalive(){
            return withNewTcpKeepaliveLike(getTcpKeepalive() != null ? getTcpKeepalive(): new TcpKeepaliveBuilder().build());
    }

    public TCPSettingsFluent.TcpKeepaliveNested<A> editOrNewTcpKeepaliveLike(TcpKeepalive item){
            return withNewTcpKeepaliveLike(getTcpKeepalive() != null ? getTcpKeepalive(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TCPSettingsFluentImpl that = (TCPSettingsFluentImpl) o;
            if (connectTimeout != null ? !connectTimeout.equals(that.connectTimeout) :that.connectTimeout != null) return false;
            if (maxConnections != null ? !maxConnections.equals(that.maxConnections) :that.maxConnections != null) return false;
            if (tcpKeepalive != null ? !tcpKeepalive.equals(that.tcpKeepalive) :that.tcpKeepalive != null) return false;
            return true;
    }


    public class ConnectTimeoutNestedImpl<N> extends DurationFluentImpl<TCPSettingsFluent.ConnectTimeoutNested<N>> implements TCPSettingsFluent.ConnectTimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ConnectTimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ConnectTimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) TCPSettingsFluentImpl.this.withConnectTimeout(builder.build());
    }
    public N endConnectTimeout(){
            return and();
    }

}
    public class TcpKeepaliveNestedImpl<N> extends TcpKeepaliveFluentImpl<TCPSettingsFluent.TcpKeepaliveNested<N>> implements TCPSettingsFluent.TcpKeepaliveNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TcpKeepaliveBuilder builder;
    
            TcpKeepaliveNestedImpl(TcpKeepalive item){
                    this.builder = new TcpKeepaliveBuilder(this, item);
            }
            TcpKeepaliveNestedImpl(){
                    this.builder = new TcpKeepaliveBuilder(this);
            }
    
    public N and(){
            return (N) TCPSettingsFluentImpl.this.withTcpKeepalive(builder.build());
    }
    public N endTcpKeepalive(){
            return and();
    }

}


}
