package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TLSMatchAttributesBuilder extends TLSMatchAttributesFluentImpl<TLSMatchAttributesBuilder> implements VisitableBuilder<TLSMatchAttributes,TLSMatchAttributesBuilder>{

    TLSMatchAttributesFluent<?> fluent;
    Boolean validationEnabled;

    public TLSMatchAttributesBuilder(){
            this(true);
    }
    public TLSMatchAttributesBuilder(Boolean validationEnabled){
            this(new TLSMatchAttributes(), validationEnabled);
    }
    public TLSMatchAttributesBuilder(TLSMatchAttributesFluent<?> fluent){
            this(fluent, true);
    }
    public TLSMatchAttributesBuilder(TLSMatchAttributesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TLSMatchAttributes(), validationEnabled);
    }
    public TLSMatchAttributesBuilder(TLSMatchAttributesFluent<?> fluent,TLSMatchAttributes instance){
            this(fluent, instance, true);
    }
    public TLSMatchAttributesBuilder(TLSMatchAttributesFluent<?> fluent,TLSMatchAttributes instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDestinationSubnets(instance.getDestinationSubnets()); 
            fluent.withGateways(instance.getGateways()); 
            fluent.withPort(instance.getPort()); 
            fluent.withSniHosts(instance.getSniHosts()); 
            fluent.withSourceLabels(instance.getSourceLabels()); 
            fluent.withSourceNamespace(instance.getSourceNamespace()); 
            this.validationEnabled = validationEnabled; 
    }
    public TLSMatchAttributesBuilder(TLSMatchAttributes instance){
            this(instance,true);
    }
    public TLSMatchAttributesBuilder(TLSMatchAttributes instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDestinationSubnets(instance.getDestinationSubnets()); 
            this.withGateways(instance.getGateways()); 
            this.withPort(instance.getPort()); 
            this.withSniHosts(instance.getSniHosts()); 
            this.withSourceLabels(instance.getSourceLabels()); 
            this.withSourceNamespace(instance.getSourceNamespace()); 
            this.validationEnabled = validationEnabled; 
    }

    public TLSMatchAttributes build(){
            TLSMatchAttributes buildable = new TLSMatchAttributes(fluent.getDestinationSubnets(),fluent.getGateways(),fluent.getPort(),fluent.getSniHosts(),fluent.getSourceLabels(),fluent.getSourceNamespace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TLSMatchAttributesBuilder that = (TLSMatchAttributesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
