package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class TLSMatchAttributesFluentImpl<A extends TLSMatchAttributesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TLSMatchAttributesFluent<A>{

    private List<String> destinationSubnets;
    private List<String> gateways;
    private Integer port;
    private List<String> sniHosts;
    private Map<String,String> sourceLabels;
    private String sourceNamespace;

    public TLSMatchAttributesFluentImpl(){
    }
    public TLSMatchAttributesFluentImpl(TLSMatchAttributes instance){
            this.withDestinationSubnets(instance.getDestinationSubnets()); 
            this.withGateways(instance.getGateways()); 
            this.withPort(instance.getPort()); 
            this.withSniHosts(instance.getSniHosts()); 
            this.withSourceLabels(instance.getSourceLabels()); 
            this.withSourceNamespace(instance.getSourceNamespace()); 
    }

    public A addToDestinationSubnets(int index,String item){
            if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
            this.destinationSubnets.add(index, item);
            return (A)this;
    }

    public A setToDestinationSubnets(int index,String item){
            if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
            this.destinationSubnets.set(index, item); return (A)this;
    }

    public A addToDestinationSubnets(String... items){
            if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
            for (String item : items) {this.destinationSubnets.add(item);} return (A)this;
    }

    public A addAllToDestinationSubnets(Collection<String> items){
            if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
            for (String item : items) {this.destinationSubnets.add(item);} return (A)this;
    }

    public A removeFromDestinationSubnets(String... items){
            for (String item : items) {if (this.destinationSubnets!= null){ this.destinationSubnets.remove(item);}} return (A)this;
    }

    public A removeAllFromDestinationSubnets(Collection<String> items){
            for (String item : items) {if (this.destinationSubnets!= null){ this.destinationSubnets.remove(item);}} return (A)this;
    }

    public List<String> getDestinationSubnets(){
            return this.destinationSubnets;
    }

    public String getDestinationSubnet(int index){
            return this.destinationSubnets.get(index);
    }

    public String getFirstDestinationSubnet(){
            return this.destinationSubnets.get(0);
    }

    public String getLastDestinationSubnet(){
            return this.destinationSubnets.get(destinationSubnets.size() - 1);
    }

    public String getMatchingDestinationSubnet(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: destinationSubnets) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDestinationSubnet(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: destinationSubnets) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDestinationSubnets(List<String> destinationSubnets){
            if (this.destinationSubnets != null) { _visitables.get("destinationSubnets").removeAll(this.destinationSubnets);}
            if (destinationSubnets != null) {this.destinationSubnets = new ArrayList<String>(); for (String item : destinationSubnets){this.addToDestinationSubnets(item);}} else { this.destinationSubnets = null;} return (A) this;
    }

    public A withDestinationSubnets(String... destinationSubnets){
            if (this.destinationSubnets != null) {this.destinationSubnets.clear();}
            if (destinationSubnets != null) {for (String item :destinationSubnets){ this.addToDestinationSubnets(item);}} return (A) this;
    }

    public Boolean hasDestinationSubnets(){
            return destinationSubnets != null && !destinationSubnets.isEmpty();
    }

    public A addNewDestinationSubnet(String arg1){
            return (A)addToDestinationSubnets(new String(arg1));
    }

    public A addNewDestinationSubnet(StringBuilder arg1){
            return (A)addToDestinationSubnets(new String(arg1));
    }

    public A addNewDestinationSubnet(StringBuffer arg1){
            return (A)addToDestinationSubnets(new String(arg1));
    }

    public A addToGateways(int index,String item){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            this.gateways.add(index, item);
            return (A)this;
    }

    public A setToGateways(int index,String item){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            this.gateways.set(index, item); return (A)this;
    }

    public A addToGateways(String... items){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            for (String item : items) {this.gateways.add(item);} return (A)this;
    }

    public A addAllToGateways(Collection<String> items){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            for (String item : items) {this.gateways.add(item);} return (A)this;
    }

    public A removeFromGateways(String... items){
            for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
    }

    public A removeAllFromGateways(Collection<String> items){
            for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
    }

    public List<String> getGateways(){
            return this.gateways;
    }

    public String getGateway(int index){
            return this.gateways.get(index);
    }

    public String getFirstGateway(){
            return this.gateways.get(0);
    }

    public String getLastGateway(){
            return this.gateways.get(gateways.size() - 1);
    }

    public String getMatchingGateway(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: gateways) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGateway(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: gateways) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withGateways(List<String> gateways){
            if (this.gateways != null) { _visitables.get("gateways").removeAll(this.gateways);}
            if (gateways != null) {this.gateways = new ArrayList<String>(); for (String item : gateways){this.addToGateways(item);}} else { this.gateways = null;} return (A) this;
    }

    public A withGateways(String... gateways){
            if (this.gateways != null) {this.gateways.clear();}
            if (gateways != null) {for (String item :gateways){ this.addToGateways(item);}} return (A) this;
    }

    public Boolean hasGateways(){
            return gateways != null && !gateways.isEmpty();
    }

    public A addNewGateway(String arg1){
            return (A)addToGateways(new String(arg1));
    }

    public A addNewGateway(StringBuilder arg1){
            return (A)addToGateways(new String(arg1));
    }

    public A addNewGateway(StringBuffer arg1){
            return (A)addToGateways(new String(arg1));
    }

    public Integer getPort(){
            return this.port;
    }

    public A withPort(Integer port){
            this.port=port; return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A addToSniHosts(int index,String item){
            if (this.sniHosts == null) {this.sniHosts = new ArrayList<String>();}
            this.sniHosts.add(index, item);
            return (A)this;
    }

    public A setToSniHosts(int index,String item){
            if (this.sniHosts == null) {this.sniHosts = new ArrayList<String>();}
            this.sniHosts.set(index, item); return (A)this;
    }

    public A addToSniHosts(String... items){
            if (this.sniHosts == null) {this.sniHosts = new ArrayList<String>();}
            for (String item : items) {this.sniHosts.add(item);} return (A)this;
    }

    public A addAllToSniHosts(Collection<String> items){
            if (this.sniHosts == null) {this.sniHosts = new ArrayList<String>();}
            for (String item : items) {this.sniHosts.add(item);} return (A)this;
    }

    public A removeFromSniHosts(String... items){
            for (String item : items) {if (this.sniHosts!= null){ this.sniHosts.remove(item);}} return (A)this;
    }

    public A removeAllFromSniHosts(Collection<String> items){
            for (String item : items) {if (this.sniHosts!= null){ this.sniHosts.remove(item);}} return (A)this;
    }

    public List<String> getSniHosts(){
            return this.sniHosts;
    }

    public String getSniHost(int index){
            return this.sniHosts.get(index);
    }

    public String getFirstSniHost(){
            return this.sniHosts.get(0);
    }

    public String getLastSniHost(){
            return this.sniHosts.get(sniHosts.size() - 1);
    }

    public String getMatchingSniHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: sniHosts) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSniHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: sniHosts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSniHosts(List<String> sniHosts){
            if (this.sniHosts != null) { _visitables.get("sniHosts").removeAll(this.sniHosts);}
            if (sniHosts != null) {this.sniHosts = new ArrayList<String>(); for (String item : sniHosts){this.addToSniHosts(item);}} else { this.sniHosts = null;} return (A) this;
    }

    public A withSniHosts(String... sniHosts){
            if (this.sniHosts != null) {this.sniHosts.clear();}
            if (sniHosts != null) {for (String item :sniHosts){ this.addToSniHosts(item);}} return (A) this;
    }

    public Boolean hasSniHosts(){
            return sniHosts != null && !sniHosts.isEmpty();
    }

    public A addNewSniHost(String arg1){
            return (A)addToSniHosts(new String(arg1));
    }

    public A addNewSniHost(StringBuilder arg1){
            return (A)addToSniHosts(new String(arg1));
    }

    public A addNewSniHost(StringBuffer arg1){
            return (A)addToSniHosts(new String(arg1));
    }

    public A addToSourceLabels(String key,String value){
            if(this.sourceLabels == null && key != null && value != null) { this.sourceLabels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.sourceLabels.put(key, value);} return (A)this;
    }

    public A addToSourceLabels(Map<String,String> map){
            if(this.sourceLabels == null && map != null) { this.sourceLabels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.sourceLabels.putAll(map);} return (A)this;
    }

    public A removeFromSourceLabels(String key){
            if(this.sourceLabels == null) { return (A) this; }
            if(key != null && this.sourceLabels != null) {this.sourceLabels.remove(key);} return (A)this;
    }

    public A removeFromSourceLabels(Map<String,String> map){
            if(this.sourceLabels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.sourceLabels != null){this.sourceLabels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getSourceLabels(){
            return this.sourceLabels;
    }

    public A withSourceLabels(Map<String,String> sourceLabels){
            if (sourceLabels == null) { this.sourceLabels =  null;} else {this.sourceLabels = new LinkedHashMap<String,String>(sourceLabels);} return (A) this;
    }

    public Boolean hasSourceLabels(){
            return this.sourceLabels != null;
    }

    public String getSourceNamespace(){
            return this.sourceNamespace;
    }

    public A withSourceNamespace(String sourceNamespace){
            this.sourceNamespace=sourceNamespace; return (A) this;
    }

    public Boolean hasSourceNamespace(){
            return this.sourceNamespace != null;
    }

    public A withNewSourceNamespace(String arg1){
            return (A)withSourceNamespace(new String(arg1));
    }

    public A withNewSourceNamespace(StringBuilder arg1){
            return (A)withSourceNamespace(new String(arg1));
    }

    public A withNewSourceNamespace(StringBuffer arg1){
            return (A)withSourceNamespace(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TLSMatchAttributesFluentImpl that = (TLSMatchAttributesFluentImpl) o;
            if (destinationSubnets != null ? !destinationSubnets.equals(that.destinationSubnets) :that.destinationSubnets != null) return false;
            if (gateways != null ? !gateways.equals(that.gateways) :that.gateways != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (sniHosts != null ? !sniHosts.equals(that.sniHosts) :that.sniHosts != null) return false;
            if (sourceLabels != null ? !sourceLabels.equals(that.sourceLabels) :that.sourceLabels != null) return false;
            if (sourceNamespace != null ? !sourceNamespace.equals(that.sourceNamespace) :that.sourceNamespace != null) return false;
            return true;
    }




}
