
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "interval",
    "probes",
    "time"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TcpKeepalive implements Serializable
{

    /**
     * 
     */
    @JsonProperty("interval")
    @JsonPropertyDescription("")
    private Duration interval;
    /**
     * 
     */
    @JsonProperty("probes")
    @JsonPropertyDescription("")
    private Integer probes;
    /**
     * 
     */
    @JsonProperty("time")
    @JsonPropertyDescription("")
    private Duration time;
    private final static long serialVersionUID = 9180060786478365517L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TcpKeepalive() {
    }

    /**
     * 
     * @param interval
     * @param probes
     * @param time
     */
    public TcpKeepalive(Duration interval, Integer probes, Duration time) {
        super();
        this.interval = interval;
        this.probes = probes;
        this.time = time;
    }

    /**
     * 
     */
    public Duration getInterval() {
        return interval;
    }

    /**
     * 
     */
    public void setInterval(Duration interval) {
        this.interval = interval;
    }

    /**
     * 
     */
    public Integer getProbes() {
        return probes;
    }

    /**
     * 
     */
    public void setProbes(Integer probes) {
        this.probes = probes;
    }

    /**
     * 
     */
    public Duration getTime() {
        return time;
    }

    /**
     * 
     */
    public void setTime(Duration time) {
        this.time = time;
    }

}
