
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "name",
    "route"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class VirtualHostMatch implements Serializable
{

    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("route")
    @JsonPropertyDescription("")
    private RouteMatch route;
    private final static long serialVersionUID = -4785932590329939907L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public VirtualHostMatch() {
    }

    /**
     * 
     * @param route
     * @param name
     */
    public VirtualHostMatch(String name, RouteMatch route) {
        super();
        this.name = name;
        this.route = route;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public RouteMatch getRoute() {
        return route;
    }

    /**
     * 
     */
    public void setRoute(RouteMatch route) {
        this.route = route;
    }

}
