package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VirtualHostMatchBuilder extends VirtualHostMatchFluentImpl<VirtualHostMatchBuilder> implements VisitableBuilder<VirtualHostMatch,VirtualHostMatchBuilder>{

    VirtualHostMatchFluent<?> fluent;
    Boolean validationEnabled;

    public VirtualHostMatchBuilder(){
            this(true);
    }
    public VirtualHostMatchBuilder(Boolean validationEnabled){
            this(new VirtualHostMatch(), validationEnabled);
    }
    public VirtualHostMatchBuilder(VirtualHostMatchFluent<?> fluent){
            this(fluent, true);
    }
    public VirtualHostMatchBuilder(VirtualHostMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VirtualHostMatch(), validationEnabled);
    }
    public VirtualHostMatchBuilder(VirtualHostMatchFluent<?> fluent,VirtualHostMatch instance){
            this(fluent, instance, true);
    }
    public VirtualHostMatchBuilder(VirtualHostMatchFluent<?> fluent,VirtualHostMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withRoute(instance.getRoute()); 
            this.validationEnabled = validationEnabled; 
    }
    public VirtualHostMatchBuilder(VirtualHostMatch instance){
            this(instance,true);
    }
    public VirtualHostMatchBuilder(VirtualHostMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withRoute(instance.getRoute()); 
            this.validationEnabled = validationEnabled; 
    }

    public VirtualHostMatch build(){
            VirtualHostMatch buildable = new VirtualHostMatch(fluent.getName(),fluent.getRoute());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VirtualHostMatchBuilder that = (VirtualHostMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
