package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class VirtualHostMatchFluentImpl<A extends VirtualHostMatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements VirtualHostMatchFluent<A>{

    private String name;
    private RouteMatchBuilder route;

    public VirtualHostMatchFluentImpl(){
    }
    public VirtualHostMatchFluentImpl(VirtualHostMatch instance){
            this.withName(instance.getName()); 
            this.withRoute(instance.getRoute()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRoute instead.
 * @return The buildable object.
 */
@Deprecated public RouteMatch getRoute(){
            return this.route!=null?this.route.build():null;
    }

    public RouteMatch buildRoute(){
            return this.route!=null?this.route.build():null;
    }

    public A withRoute(RouteMatch route){
            _visitables.get("route").remove(this.route);
            if (route!=null){ this.route= new RouteMatchBuilder(route); _visitables.get("route").add(this.route);} return (A) this;
    }

    public Boolean hasRoute(){
            return this.route != null;
    }

    public VirtualHostMatchFluent.RouteNested<A> withNewRoute(){
            return new RouteNestedImpl();
    }

    public VirtualHostMatchFluent.RouteNested<A> withNewRouteLike(RouteMatch item){
            return new RouteNestedImpl(item);
    }

    public VirtualHostMatchFluent.RouteNested<A> editRoute(){
            return withNewRouteLike(getRoute());
    }

    public VirtualHostMatchFluent.RouteNested<A> editOrNewRoute(){
            return withNewRouteLike(getRoute() != null ? getRoute(): new RouteMatchBuilder().build());
    }

    public VirtualHostMatchFluent.RouteNested<A> editOrNewRouteLike(RouteMatch item){
            return withNewRouteLike(getRoute() != null ? getRoute(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            VirtualHostMatchFluentImpl that = (VirtualHostMatchFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (route != null ? !route.equals(that.route) :that.route != null) return false;
            return true;
    }


    public class RouteNestedImpl<N> extends RouteMatchFluentImpl<VirtualHostMatchFluent.RouteNested<N>> implements VirtualHostMatchFluent.RouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteMatchBuilder builder;
    
            RouteNestedImpl(RouteMatch item){
                    this.builder = new RouteMatchBuilder(this, item);
            }
            RouteNestedImpl(){
                    this.builder = new RouteMatchBuilder(this);
            }
    
    public N and(){
            return (N) VirtualHostMatchFluentImpl.this.withRoute(builder.build());
    }
    public N endRoute(){
            return and();
    }

}


}
