package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class WorkloadEntryBuilder extends WorkloadEntryFluentImpl<WorkloadEntryBuilder> implements VisitableBuilder<WorkloadEntry,WorkloadEntryBuilder>{

    WorkloadEntryFluent<?> fluent;
    Boolean validationEnabled;

    public WorkloadEntryBuilder(){
            this(true);
    }
    public WorkloadEntryBuilder(Boolean validationEnabled){
            this(new WorkloadEntry(), validationEnabled);
    }
    public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent){
            this(fluent, true);
    }
    public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new WorkloadEntry(), validationEnabled);
    }
    public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent,WorkloadEntry instance){
            this(fluent, instance, true);
    }
    public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent,WorkloadEntry instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public WorkloadEntryBuilder(WorkloadEntry instance){
            this(instance,true);
    }
    public WorkloadEntryBuilder(WorkloadEntry instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public WorkloadEntry build(){
            WorkloadEntry buildable = new WorkloadEntry(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            WorkloadEntryBuilder that = (WorkloadEntryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
