package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class WorkloadEntryListBuilder extends WorkloadEntryListFluentImpl<WorkloadEntryListBuilder> implements VisitableBuilder<WorkloadEntryList,WorkloadEntryListBuilder>{

    WorkloadEntryListFluent<?> fluent;
    Boolean validationEnabled;

    public WorkloadEntryListBuilder(){
            this(true);
    }
    public WorkloadEntryListBuilder(Boolean validationEnabled){
            this(new WorkloadEntryList(), validationEnabled);
    }
    public WorkloadEntryListBuilder(WorkloadEntryListFluent<?> fluent){
            this(fluent, true);
    }
    public WorkloadEntryListBuilder(WorkloadEntryListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new WorkloadEntryList(), validationEnabled);
    }
    public WorkloadEntryListBuilder(WorkloadEntryListFluent<?> fluent,WorkloadEntryList instance){
            this(fluent, instance, true);
    }
    public WorkloadEntryListBuilder(WorkloadEntryListFluent<?> fluent,WorkloadEntryList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public WorkloadEntryListBuilder(WorkloadEntryList instance){
            this(instance,true);
    }
    public WorkloadEntryListBuilder(WorkloadEntryList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public WorkloadEntryList build(){
            WorkloadEntryList buildable = new WorkloadEntryList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            WorkloadEntryListBuilder that = (WorkloadEntryListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
