
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "labels",
    "locality",
    "network",
    "ports",
    "serviceAccount",
    "weight"
})
@IstioKind(name = "WorkloadEntry", plural = "workloadentries")
@IstioApiVersion("networking.istio.io/v1alpha3")
@Version("v1alpha3")
@Group("networking.istio.io")
@Plural("workloadentries")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class WorkloadEntrySpec implements Serializable, IstioSpec
{

    /**
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private java.lang.String address;
    /**
     * 
     */
    @JsonProperty("labels")
    @JsonPropertyDescription("")
    private Map<String, String> labels;
    /**
     * 
     */
    @JsonProperty("locality")
    @JsonPropertyDescription("")
    private java.lang.String locality;
    /**
     * 
     */
    @JsonProperty("network")
    @JsonPropertyDescription("")
    private java.lang.String network;
    /**
     * 
     */
    @JsonProperty("ports")
    @JsonPropertyDescription("")
    private Map<String, Integer> ports;
    /**
     * 
     */
    @JsonProperty("serviceAccount")
    @JsonPropertyDescription("")
    private java.lang.String serviceAccount;
    /**
     * 
     */
    @JsonProperty("weight")
    @JsonPropertyDescription("")
    private java.lang.Integer weight;
    private final static long serialVersionUID = -1842264223489035706L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public WorkloadEntrySpec() {
    }

    /**
     * 
     * @param address
     * @param locality
     * @param weight
     * @param serviceAccount
     * @param ports
     * @param labels
     * @param network
     */
    public WorkloadEntrySpec(java.lang.String address, Map<String, String> labels, java.lang.String locality, java.lang.String network, Map<String, Integer> ports, java.lang.String serviceAccount, java.lang.Integer weight) {
        super();
        this.address = address;
        this.labels = labels;
        this.locality = locality;
        this.network = network;
        this.ports = ports;
        this.serviceAccount = serviceAccount;
        this.weight = weight;
    }

    /**
     * 
     */
    public java.lang.String getAddress() {
        return address;
    }

    /**
     * 
     */
    public void setAddress(java.lang.String address) {
        this.address = address;
    }

    /**
     * 
     */
    public Map<String, String> getLabels() {
        return labels;
    }

    /**
     * 
     */
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    /**
     * 
     */
    public java.lang.String getLocality() {
        return locality;
    }

    /**
     * 
     */
    public void setLocality(java.lang.String locality) {
        this.locality = locality;
    }

    /**
     * 
     */
    public java.lang.String getNetwork() {
        return network;
    }

    /**
     * 
     */
    public void setNetwork(java.lang.String network) {
        this.network = network;
    }

    /**
     * 
     */
    public Map<String, Integer> getPorts() {
        return ports;
    }

    /**
     * 
     */
    public void setPorts(Map<String, Integer> ports) {
        this.ports = ports;
    }

    /**
     * 
     */
    public java.lang.String getServiceAccount() {
        return serviceAccount;
    }

    /**
     * 
     */
    public void setServiceAccount(java.lang.String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    /**
     * 
     */
    public java.lang.Integer getWeight() {
        return weight;
    }

    /**
     * 
     */
    public void setWeight(java.lang.Integer weight) {
        this.weight = weight;
    }

}
