
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "caCertificates",
    "clientCertificate",
    "credentialName",
    "mode",
    "privateKey",
    "sni",
    "subjectAltNames"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ClientTLSSettings implements Serializable
{

    /**
     * 
     */
    @JsonProperty("caCertificates")
    @JsonPropertyDescription("")
    private String caCertificates;
    /**
     * 
     */
    @JsonProperty("clientCertificate")
    @JsonPropertyDescription("")
    private String clientCertificate;
    /**
     * 
     */
    @JsonProperty("credentialName")
    @JsonPropertyDescription("")
    private String credentialName;
    @JsonProperty("mode")
    private ClientTLSSettingsMode mode;
    /**
     * 
     */
    @JsonProperty("privateKey")
    @JsonPropertyDescription("")
    private String privateKey;
    /**
     * 
     */
    @JsonProperty("sni")
    @JsonPropertyDescription("")
    private String sni;
    /**
     * 
     */
    @JsonProperty("subjectAltNames")
    @JsonPropertyDescription("")
    private List<String> subjectAltNames = new ArrayList<String>();
    private final static long serialVersionUID = 7021028995466668351L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ClientTLSSettings() {
    }

    /**
     * 
     * @param mode
     * @param privateKey
     * @param clientCertificate
     * @param caCertificates
     * @param subjectAltNames
     * @param credentialName
     * @param sni
     */
    public ClientTLSSettings(String caCertificates, String clientCertificate, String credentialName, ClientTLSSettingsMode mode, String privateKey, String sni, List<String> subjectAltNames) {
        super();
        this.caCertificates = caCertificates;
        this.clientCertificate = clientCertificate;
        this.credentialName = credentialName;
        this.mode = mode;
        this.privateKey = privateKey;
        this.sni = sni;
        this.subjectAltNames = subjectAltNames;
    }

    /**
     * 
     */
    public String getCaCertificates() {
        return caCertificates;
    }

    /**
     * 
     */
    public void setCaCertificates(String caCertificates) {
        this.caCertificates = caCertificates;
    }

    /**
     * 
     */
    public String getClientCertificate() {
        return clientCertificate;
    }

    /**
     * 
     */
    public void setClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    /**
     * 
     */
    public String getCredentialName() {
        return credentialName;
    }

    /**
     * 
     */
    public void setCredentialName(String credentialName) {
        this.credentialName = credentialName;
    }

    public ClientTLSSettingsMode getMode() {
        return mode;
    }

    public void setMode(ClientTLSSettingsMode mode) {
        this.mode = mode;
    }

    /**
     * 
     */
    public String getPrivateKey() {
        return privateKey;
    }

    /**
     * 
     */
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    /**
     * 
     */
    public String getSni() {
        return sni;
    }

    /**
     * 
     */
    public void setSni(String sni) {
        this.sni = sni;
    }

    /**
     * 
     */
    public List<String> getSubjectAltNames() {
        return subjectAltNames;
    }

    /**
     * 
     */
    public void setSubjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
    }

}
