package me.snowdrop.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClientTLSSettingsBuilder extends me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsFluentImpl<me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder> implements VisitableBuilder<me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings,me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder>{

    me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public ClientTLSSettingsBuilder(){
            this(true);
    }
    public ClientTLSSettingsBuilder(Boolean validationEnabled){
            this(new ClientTLSSettings(), validationEnabled);
    }
    public ClientTLSSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public ClientTLSSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClientTLSSettings(), validationEnabled);
    }
    public ClientTLSSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings instance){
            this(fluent, instance, true);
    }
    public ClientTLSSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCaCertificates(instance.getCaCertificates()); 
            fluent.withClientCertificate(instance.getClientCertificate()); 
            fluent.withCredentialName(instance.getCredentialName()); 
            fluent.withMode(instance.getMode()); 
            fluent.withPrivateKey(instance.getPrivateKey()); 
            fluent.withSni(instance.getSni()); 
            fluent.withSubjectAltNames(instance.getSubjectAltNames()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClientTLSSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings instance){
            this(instance,true);
    }
    public ClientTLSSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCaCertificates(instance.getCaCertificates()); 
            this.withClientCertificate(instance.getClientCertificate()); 
            this.withCredentialName(instance.getCredentialName()); 
            this.withMode(instance.getMode()); 
            this.withPrivateKey(instance.getPrivateKey()); 
            this.withSni(instance.getSni()); 
            this.withSubjectAltNames(instance.getSubjectAltNames()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings build(){
            ClientTLSSettings buildable = new ClientTLSSettings(fluent.getCaCertificates(),fluent.getClientCertificate(),fluent.getCredentialName(),fluent.getMode(),fluent.getPrivateKey(),fluent.getSni(),fluent.getSubjectAltNames());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClientTLSSettingsBuilder that = (ClientTLSSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
