
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings.LbPolicy;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "consistentHash"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ConsistentHashLbPolicy implements Serializable, LbPolicy
{

    /**
     * 
     */
    @JsonProperty("consistentHash")
    @JsonPropertyDescription("")
    private ConsistentHashLB consistentHash;
    private final static long serialVersionUID = -6309970089453895590L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ConsistentHashLbPolicy() {
    }

    /**
     * 
     * @param consistentHash
     */
    public ConsistentHashLbPolicy(ConsistentHashLB consistentHash) {
        super();
        this.consistentHash = consistentHash;
    }

    /**
     * 
     */
    public ConsistentHashLB getConsistentHash() {
        return consistentHash;
    }

    /**
     * 
     */
    public void setConsistentHash(ConsistentHashLB consistentHash) {
        this.consistentHash = consistentHash;
    }

}
