
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "name",
    "namespace"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Delegate implements Serializable
{

    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("namespace")
    @JsonPropertyDescription("")
    private String namespace;
    private final static long serialVersionUID = 3199112104726805396L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Delegate() {
    }

    /**
     * 
     * @param name
     * @param namespace
     */
    public Delegate(String name, String namespace) {
        super();
        this.name = name;
        this.namespace = namespace;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * 
     */
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

}
