package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class DestinationFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.DestinationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.DestinationFluent<A>{

    private String host;
    private me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder port;
    private String subset;

    public DestinationFluentImpl(){
    }
    public DestinationFluentImpl(me.snowdrop.istio.api.networking.v1beta1.Destination instance){
            this.withHost(instance.getHost()); 
            this.withPort(instance.getPort()); 
            this.withSubset(instance.getSubset()); 
    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    public A withNewHost(String arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuilder arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1){
            return (A)withHost(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.PortSelector getPort(){
            return this.port!=null?this.port.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.PortSelector buildPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(me.snowdrop.istio.api.networking.v1beta1.PortSelector port){
            _visitables.get("port").remove(this.port);
            if (port!=null){ this.port= new me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNewPort(Integer number){
            return (A)withPort(new PortSelector(number));
    }

    public DestinationFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public DestinationFluent.PortNested<A> withNewPortLike(me.snowdrop.istio.api.networking.v1beta1.PortSelector item){
            return new PortNestedImpl(item);
    }

    public DestinationFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public DestinationFluent.PortNested<A> editOrNewPort(){
            return withNewPortLike(getPort() != null ? getPort(): new me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder().build());
    }

    public DestinationFluent.PortNested<A> editOrNewPortLike(me.snowdrop.istio.api.networking.v1beta1.PortSelector item){
            return withNewPortLike(getPort() != null ? getPort(): item);
    }

    public String getSubset(){
            return this.subset;
    }

    public A withSubset(String subset){
            this.subset=subset; return (A) this;
    }

    public Boolean hasSubset(){
            return this.subset != null;
    }

    public A withNewSubset(String arg1){
            return (A)withSubset(new String(arg1));
    }

    public A withNewSubset(StringBuilder arg1){
            return (A)withSubset(new String(arg1));
    }

    public A withNewSubset(StringBuffer arg1){
            return (A)withSubset(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DestinationFluentImpl that = (DestinationFluentImpl) o;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (subset != null ? !subset.equals(that.subset) :that.subset != null) return false;
            return true;
    }


    public class PortNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.PortSelectorFluentImpl<DestinationFluent.PortNested<N>> implements DestinationFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder builder;
    
            PortNestedImpl(me.snowdrop.istio.api.networking.v1beta1.PortSelector item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder(this, item);
            }
            PortNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder(this);
            }
    
    public N and(){
            return (N) DestinationFluentImpl.this.withPort(builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
