
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "exportTo",
    "host",
    "subsets",
    "trafficPolicy"
})
@IstioKind(name = "DestinationRule", plural = "destinationrules")
@IstioApiVersion("networking.istio.io/v1beta1")
@Version("v1beta1")
@Group("networking.istio.io")
@Plural("destinationrules")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class DestinationRuleSpec implements Serializable, IstioSpec
{

    /**
     * 
     */
    @JsonProperty("exportTo")
    @JsonPropertyDescription("")
    private List<String> exportTo = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("host")
    @JsonPropertyDescription("")
    private String host;
    /**
     * 
     */
    @JsonProperty("subsets")
    @JsonPropertyDescription("")
    private List<Subset> subsets = new ArrayList<Subset>();
    /**
     * 
     */
    @JsonProperty("trafficPolicy")
    @JsonPropertyDescription("")
    private TrafficPolicy trafficPolicy;
    private final static long serialVersionUID = -1050967674242654886L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DestinationRuleSpec() {
    }

    /**
     * 
     * @param host
     * @param exportTo
     * @param subsets
     * @param trafficPolicy
     */
    public DestinationRuleSpec(List<String> exportTo, String host, List<Subset> subsets, TrafficPolicy trafficPolicy) {
        super();
        this.exportTo = exportTo;
        this.host = host;
        this.subsets = subsets;
        this.trafficPolicy = trafficPolicy;
    }

    /**
     * 
     */
    public List<String> getExportTo() {
        return exportTo;
    }

    /**
     * 
     */
    public void setExportTo(List<String> exportTo) {
        this.exportTo = exportTo;
    }

    /**
     * 
     */
    public String getHost() {
        return host;
    }

    /**
     * 
     */
    public void setHost(String host) {
        this.host = host;
    }

    /**
     * 
     */
    public List<Subset> getSubsets() {
        return subsets;
    }

    /**
     * 
     */
    public void setSubsets(List<Subset> subsets) {
        this.subsets = subsets;
    }

    /**
     * 
     */
    public TrafficPolicy getTrafficPolicy() {
        return trafficPolicy;
    }

    /**
     * 
     */
    public void setTrafficPolicy(TrafficPolicy trafficPolicy) {
        this.trafficPolicy = trafficPolicy;
    }

}
