
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "from",
    "to"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Distribute implements Serializable
{

    /**
     * 
     */
    @JsonProperty("from")
    @JsonPropertyDescription("")
    private java.lang.String from;
    /**
     * 
     */
    @JsonProperty("to")
    @JsonPropertyDescription("")
    private Map<String, Integer> to;
    private final static long serialVersionUID = -2053943162796289165L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Distribute() {
    }

    /**
     * 
     * @param from
     * @param to
     */
    public Distribute(java.lang.String from, Map<String, Integer> to) {
        super();
        this.from = from;
        this.to = to;
    }

    /**
     * 
     */
    public java.lang.String getFrom() {
        return from;
    }

    /**
     * 
     */
    public void setFrom(java.lang.String from) {
        this.from = from;
    }

    /**
     * 
     */
    public Map<String, Integer> getTo() {
        return to;
    }

    /**
     * 
     */
    public void setTo(Map<String, Integer> to) {
        this.to = to;
    }

}
