package me.snowdrop.istio.api.networking.v1beta1;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class HTTPCookieFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.HTTPCookieFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.HTTPCookieFluent<A>{

    private String name;
    private String path;
    private DurationBuilder ttl;

    public HTTPCookieFluentImpl(){
    }
    public HTTPCookieFluentImpl(me.snowdrop.istio.api.networking.v1beta1.HTTPCookie instance){
            this.withName(instance.getName()); 
            this.withPath(instance.getPath()); 
            this.withTtl(instance.getTtl()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public Boolean hasPath(){
            return this.path != null;
    }

    public A withNewPath(String arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1){
            return (A)withPath(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTtl instead.
 * @return The buildable object.
 */
@Deprecated public Duration getTtl(){
            return this.ttl!=null?this.ttl.build():null;
    }

    public Duration buildTtl(){
            return this.ttl!=null?this.ttl.build():null;
    }

    public A withTtl(Duration ttl){
            _visitables.get("ttl").remove(this.ttl);
            if (ttl!=null){ this.ttl= new DurationBuilder(ttl); _visitables.get("ttl").add(this.ttl);} return (A) this;
    }

    public Boolean hasTtl(){
            return this.ttl != null;
    }

    public A withNewTtl(Integer nanos,Long seconds){
            return (A)withTtl(new Duration(nanos, seconds));
    }

    public HTTPCookieFluent.TtlNested<A> withNewTtl(){
            return new TtlNestedImpl();
    }

    public HTTPCookieFluent.TtlNested<A> withNewTtlLike(Duration item){
            return new TtlNestedImpl(item);
    }

    public HTTPCookieFluent.TtlNested<A> editTtl(){
            return withNewTtlLike(getTtl());
    }

    public HTTPCookieFluent.TtlNested<A> editOrNewTtl(){
            return withNewTtlLike(getTtl() != null ? getTtl(): new DurationBuilder().build());
    }

    public HTTPCookieFluent.TtlNested<A> editOrNewTtlLike(Duration item){
            return withNewTtlLike(getTtl() != null ? getTtl(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HTTPCookieFluentImpl that = (HTTPCookieFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            if (ttl != null ? !ttl.equals(that.ttl) :that.ttl != null) return false;
            return true;
    }


    public class TtlNestedImpl<N> extends DurationFluentImpl<HTTPCookieFluent.TtlNested<N>> implements HTTPCookieFluent.TtlNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            TtlNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            TtlNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) HTTPCookieFluentImpl.this.withTtl(builder.build());
    }
    public N endTtl(){
            return and();
    }

}


}
