package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class HTTPMatchRequestFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestFluent<A>{

    private me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder authority;
    private List<String> gateways;
    private Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> headers;
    private Boolean ignoreUriCase;
    private me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder method;
    private String name;
    private Integer port;
    private Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> queryParams;
    private me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder scheme;
    private Map<String,String> sourceLabels;
    private String sourceNamespace;
    private me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder uri;
    private Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> withoutHeaders;

    public HTTPMatchRequestFluentImpl(){
    }
    public HTTPMatchRequestFluentImpl(me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest instance){
            this.withAuthority(instance.getAuthority()); 
            this.withGateways(instance.getGateways()); 
            this.withHeaders(instance.getHeaders()); 
            this.withIgnoreUriCase(instance.getIgnoreUriCase()); 
            this.withMethod(instance.getMethod()); 
            this.withName(instance.getName()); 
            this.withPort(instance.getPort()); 
            this.withQueryParams(instance.getQueryParams()); 
            this.withScheme(instance.getScheme()); 
            this.withSourceLabels(instance.getSourceLabels()); 
            this.withSourceNamespace(instance.getSourceNamespace()); 
            this.withUri(instance.getUri()); 
            this.withWithoutHeaders(instance.getWithoutHeaders()); 
    }

    
/**
 * This method has been deprecated, please use method buildAuthority instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.StringMatch getAuthority(){
            return this.authority!=null?this.authority.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.StringMatch buildAuthority(){
            return this.authority!=null?this.authority.build():null;
    }

    public A withAuthority(me.snowdrop.istio.api.networking.v1beta1.StringMatch authority){
            _visitables.get("authority").remove(this.authority);
            if (authority!=null){ this.authority= new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(authority); _visitables.get("authority").add(this.authority);} return (A) this;
    }

    public Boolean hasAuthority(){
            return this.authority != null;
    }

    public HTTPMatchRequestFluent.AuthorityNested<A> withNewAuthority(){
            return new AuthorityNestedImpl();
    }

    public HTTPMatchRequestFluent.AuthorityNested<A> withNewAuthorityLike(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
            return new AuthorityNestedImpl(item);
    }

    public HTTPMatchRequestFluent.AuthorityNested<A> editAuthority(){
            return withNewAuthorityLike(getAuthority());
    }

    public HTTPMatchRequestFluent.AuthorityNested<A> editOrNewAuthority(){
            return withNewAuthorityLike(getAuthority() != null ? getAuthority(): new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder().build());
    }

    public HTTPMatchRequestFluent.AuthorityNested<A> editOrNewAuthorityLike(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
            return withNewAuthorityLike(getAuthority() != null ? getAuthority(): item);
    }

    public A addToGateways(int index,String item){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            this.gateways.add(index, item);
            return (A)this;
    }

    public A setToGateways(int index,String item){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            this.gateways.set(index, item); return (A)this;
    }

    public A addToGateways(String... items){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            for (String item : items) {this.gateways.add(item);} return (A)this;
    }

    public A addAllToGateways(Collection<String> items){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            for (String item : items) {this.gateways.add(item);} return (A)this;
    }

    public A removeFromGateways(String... items){
            for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
    }

    public A removeAllFromGateways(Collection<String> items){
            for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
    }

    public List<String> getGateways(){
            return this.gateways;
    }

    public String getGateway(int index){
            return this.gateways.get(index);
    }

    public String getFirstGateway(){
            return this.gateways.get(0);
    }

    public String getLastGateway(){
            return this.gateways.get(gateways.size() - 1);
    }

    public String getMatchingGateway(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: gateways) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGateway(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: gateways) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withGateways(List<String> gateways){
            if (this.gateways != null) { _visitables.get("gateways").removeAll(this.gateways);}
            if (gateways != null) {this.gateways = new ArrayList<String>(); for (String item : gateways){this.addToGateways(item);}} else { this.gateways = null;} return (A) this;
    }

    public A withGateways(String... gateways){
            if (this.gateways != null) {this.gateways.clear();}
            if (gateways != null) {for (String item :gateways){ this.addToGateways(item);}} return (A) this;
    }

    public Boolean hasGateways(){
            return gateways != null && !gateways.isEmpty();
    }

    public A addNewGateway(String arg1){
            return (A)addToGateways(new String(arg1));
    }

    public A addNewGateway(StringBuilder arg1){
            return (A)addToGateways(new String(arg1));
    }

    public A addNewGateway(StringBuffer arg1){
            return (A)addToGateways(new String(arg1));
    }

    public A addToHeaders(String key,me.snowdrop.istio.api.networking.v1beta1.StringMatch value){
            if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch>(); }
            if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
    }

    public A addToHeaders(Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> map){
            if(this.headers == null && map != null) { this.headers = new LinkedHashMap<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch>(); }
            if(map != null) { this.headers.putAll(map);} return (A)this;
    }

    public A removeFromHeaders(String key){
            if(this.headers == null) { return (A) this; }
            if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
    }

    public A removeFromHeaders(Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> map){
            if(this.headers == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
    }

    public Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> getHeaders(){
            return this.headers;
    }

    public A withHeaders(Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> headers){
            if (headers == null) { this.headers =  null;} else {this.headers = new LinkedHashMap<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch>(headers);} return (A) this;
    }

    public Boolean hasHeaders(){
            return this.headers != null;
    }

    public Boolean isIgnoreUriCase(){
            return this.ignoreUriCase;
    }

    public A withIgnoreUriCase(Boolean ignoreUriCase){
            this.ignoreUriCase=ignoreUriCase; return (A) this;
    }

    public Boolean hasIgnoreUriCase(){
            return this.ignoreUriCase != null;
    }

    public A withNewIgnoreUriCase(String arg1){
            return (A)withIgnoreUriCase(new Boolean(arg1));
    }

    public A withNewIgnoreUriCase(boolean arg1){
            return (A)withIgnoreUriCase(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMethod instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.StringMatch getMethod(){
            return this.method!=null?this.method.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.StringMatch buildMethod(){
            return this.method!=null?this.method.build():null;
    }

    public A withMethod(me.snowdrop.istio.api.networking.v1beta1.StringMatch method){
            _visitables.get("method").remove(this.method);
            if (method!=null){ this.method= new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(method); _visitables.get("method").add(this.method);} return (A) this;
    }

    public Boolean hasMethod(){
            return this.method != null;
    }

    public HTTPMatchRequestFluent.MethodNested<A> withNewMethod(){
            return new MethodNestedImpl();
    }

    public HTTPMatchRequestFluent.MethodNested<A> withNewMethodLike(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
            return new MethodNestedImpl(item);
    }

    public HTTPMatchRequestFluent.MethodNested<A> editMethod(){
            return withNewMethodLike(getMethod());
    }

    public HTTPMatchRequestFluent.MethodNested<A> editOrNewMethod(){
            return withNewMethodLike(getMethod() != null ? getMethod(): new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder().build());
    }

    public HTTPMatchRequestFluent.MethodNested<A> editOrNewMethodLike(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
            return withNewMethodLike(getMethod() != null ? getMethod(): item);
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public Integer getPort(){
            return this.port;
    }

    public A withPort(Integer port){
            this.port=port; return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A addToQueryParams(String key,me.snowdrop.istio.api.networking.v1beta1.StringMatch value){
            if(this.queryParams == null && key != null && value != null) { this.queryParams = new LinkedHashMap<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch>(); }
            if(key != null && value != null) {this.queryParams.put(key, value);} return (A)this;
    }

    public A addToQueryParams(Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> map){
            if(this.queryParams == null && map != null) { this.queryParams = new LinkedHashMap<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch>(); }
            if(map != null) { this.queryParams.putAll(map);} return (A)this;
    }

    public A removeFromQueryParams(String key){
            if(this.queryParams == null) { return (A) this; }
            if(key != null && this.queryParams != null) {this.queryParams.remove(key);} return (A)this;
    }

    public A removeFromQueryParams(Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> map){
            if(this.queryParams == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.queryParams != null){this.queryParams.remove(key);}}} return (A)this;
    }

    public Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> getQueryParams(){
            return this.queryParams;
    }

    public A withQueryParams(Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> queryParams){
            if (queryParams == null) { this.queryParams =  null;} else {this.queryParams = new LinkedHashMap<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch>(queryParams);} return (A) this;
    }

    public Boolean hasQueryParams(){
            return this.queryParams != null;
    }

    
/**
 * This method has been deprecated, please use method buildScheme instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.StringMatch getScheme(){
            return this.scheme!=null?this.scheme.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.StringMatch buildScheme(){
            return this.scheme!=null?this.scheme.build():null;
    }

    public A withScheme(me.snowdrop.istio.api.networking.v1beta1.StringMatch scheme){
            _visitables.get("scheme").remove(this.scheme);
            if (scheme!=null){ this.scheme= new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(scheme); _visitables.get("scheme").add(this.scheme);} return (A) this;
    }

    public Boolean hasScheme(){
            return this.scheme != null;
    }

    public HTTPMatchRequestFluent.SchemeNested<A> withNewScheme(){
            return new SchemeNestedImpl();
    }

    public HTTPMatchRequestFluent.SchemeNested<A> withNewSchemeLike(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
            return new SchemeNestedImpl(item);
    }

    public HTTPMatchRequestFluent.SchemeNested<A> editScheme(){
            return withNewSchemeLike(getScheme());
    }

    public HTTPMatchRequestFluent.SchemeNested<A> editOrNewScheme(){
            return withNewSchemeLike(getScheme() != null ? getScheme(): new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder().build());
    }

    public HTTPMatchRequestFluent.SchemeNested<A> editOrNewSchemeLike(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
            return withNewSchemeLike(getScheme() != null ? getScheme(): item);
    }

    public A addToSourceLabels(String key,String value){
            if(this.sourceLabels == null && key != null && value != null) { this.sourceLabels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.sourceLabels.put(key, value);} return (A)this;
    }

    public A addToSourceLabels(Map<String,String> map){
            if(this.sourceLabels == null && map != null) { this.sourceLabels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.sourceLabels.putAll(map);} return (A)this;
    }

    public A removeFromSourceLabels(String key){
            if(this.sourceLabels == null) { return (A) this; }
            if(key != null && this.sourceLabels != null) {this.sourceLabels.remove(key);} return (A)this;
    }

    public A removeFromSourceLabels(Map<String,String> map){
            if(this.sourceLabels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.sourceLabels != null){this.sourceLabels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getSourceLabels(){
            return this.sourceLabels;
    }

    public A withSourceLabels(Map<String,String> sourceLabels){
            if (sourceLabels == null) { this.sourceLabels =  null;} else {this.sourceLabels = new LinkedHashMap<String,String>(sourceLabels);} return (A) this;
    }

    public Boolean hasSourceLabels(){
            return this.sourceLabels != null;
    }

    public String getSourceNamespace(){
            return this.sourceNamespace;
    }

    public A withSourceNamespace(String sourceNamespace){
            this.sourceNamespace=sourceNamespace; return (A) this;
    }

    public Boolean hasSourceNamespace(){
            return this.sourceNamespace != null;
    }

    public A withNewSourceNamespace(String arg1){
            return (A)withSourceNamespace(new String(arg1));
    }

    public A withNewSourceNamespace(StringBuilder arg1){
            return (A)withSourceNamespace(new String(arg1));
    }

    public A withNewSourceNamespace(StringBuffer arg1){
            return (A)withSourceNamespace(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildUri instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.StringMatch getUri(){
            return this.uri!=null?this.uri.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.StringMatch buildUri(){
            return this.uri!=null?this.uri.build():null;
    }

    public A withUri(me.snowdrop.istio.api.networking.v1beta1.StringMatch uri){
            _visitables.get("uri").remove(this.uri);
            if (uri!=null){ this.uri= new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(uri); _visitables.get("uri").add(this.uri);} return (A) this;
    }

    public Boolean hasUri(){
            return this.uri != null;
    }

    public HTTPMatchRequestFluent.UriNested<A> withNewUri(){
            return new UriNestedImpl();
    }

    public HTTPMatchRequestFluent.UriNested<A> withNewUriLike(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
            return new UriNestedImpl(item);
    }

    public HTTPMatchRequestFluent.UriNested<A> editUri(){
            return withNewUriLike(getUri());
    }

    public HTTPMatchRequestFluent.UriNested<A> editOrNewUri(){
            return withNewUriLike(getUri() != null ? getUri(): new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder().build());
    }

    public HTTPMatchRequestFluent.UriNested<A> editOrNewUriLike(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
            return withNewUriLike(getUri() != null ? getUri(): item);
    }

    public A addToWithoutHeaders(String key,me.snowdrop.istio.api.networking.v1beta1.StringMatch value){
            if(this.withoutHeaders == null && key != null && value != null) { this.withoutHeaders = new LinkedHashMap<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch>(); }
            if(key != null && value != null) {this.withoutHeaders.put(key, value);} return (A)this;
    }

    public A addToWithoutHeaders(Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> map){
            if(this.withoutHeaders == null && map != null) { this.withoutHeaders = new LinkedHashMap<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch>(); }
            if(map != null) { this.withoutHeaders.putAll(map);} return (A)this;
    }

    public A removeFromWithoutHeaders(String key){
            if(this.withoutHeaders == null) { return (A) this; }
            if(key != null && this.withoutHeaders != null) {this.withoutHeaders.remove(key);} return (A)this;
    }

    public A removeFromWithoutHeaders(Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> map){
            if(this.withoutHeaders == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.withoutHeaders != null){this.withoutHeaders.remove(key);}}} return (A)this;
    }

    public Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> getWithoutHeaders(){
            return this.withoutHeaders;
    }

    public A withWithoutHeaders(Map<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch> withoutHeaders){
            if (withoutHeaders == null) { this.withoutHeaders =  null;} else {this.withoutHeaders = new LinkedHashMap<String,me.snowdrop.istio.api.networking.v1beta1.StringMatch>(withoutHeaders);} return (A) this;
    }

    public Boolean hasWithoutHeaders(){
            return this.withoutHeaders != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HTTPMatchRequestFluentImpl that = (HTTPMatchRequestFluentImpl) o;
            if (authority != null ? !authority.equals(that.authority) :that.authority != null) return false;
            if (gateways != null ? !gateways.equals(that.gateways) :that.gateways != null) return false;
            if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
            if (ignoreUriCase != null ? !ignoreUriCase.equals(that.ignoreUriCase) :that.ignoreUriCase != null) return false;
            if (method != null ? !method.equals(that.method) :that.method != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (queryParams != null ? !queryParams.equals(that.queryParams) :that.queryParams != null) return false;
            if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
            if (sourceLabels != null ? !sourceLabels.equals(that.sourceLabels) :that.sourceLabels != null) return false;
            if (sourceNamespace != null ? !sourceNamespace.equals(that.sourceNamespace) :that.sourceNamespace != null) return false;
            if (uri != null ? !uri.equals(that.uri) :that.uri != null) return false;
            if (withoutHeaders != null ? !withoutHeaders.equals(that.withoutHeaders) :that.withoutHeaders != null) return false;
            return true;
    }


    public class AuthorityNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.StringMatchFluentImpl<HTTPMatchRequestFluent.AuthorityNested<N>> implements HTTPMatchRequestFluent.AuthorityNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder builder;
    
            AuthorityNestedImpl(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(this, item);
            }
            AuthorityNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) HTTPMatchRequestFluentImpl.this.withAuthority(builder.build());
    }
    public N endAuthority(){
            return and();
    }

}
    public class MethodNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.StringMatchFluentImpl<HTTPMatchRequestFluent.MethodNested<N>> implements HTTPMatchRequestFluent.MethodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder builder;
    
            MethodNestedImpl(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(this, item);
            }
            MethodNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) HTTPMatchRequestFluentImpl.this.withMethod(builder.build());
    }
    public N endMethod(){
            return and();
    }

}
    public class SchemeNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.StringMatchFluentImpl<HTTPMatchRequestFluent.SchemeNested<N>> implements HTTPMatchRequestFluent.SchemeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder builder;
    
            SchemeNestedImpl(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(this, item);
            }
            SchemeNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) HTTPMatchRequestFluentImpl.this.withScheme(builder.build());
    }
    public N endScheme(){
            return and();
    }

}
    public class UriNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.StringMatchFluentImpl<HTTPMatchRequestFluent.UriNested<N>> implements HTTPMatchRequestFluent.UriNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder builder;
    
            UriNestedImpl(me.snowdrop.istio.api.networking.v1beta1.StringMatch item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(this, item);
            }
            UriNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.StringMatchBuilder(this);
            }
    
    public N and(){
            return (N) HTTPMatchRequestFluentImpl.this.withUri(builder.build());
    }
    public N endUri(){
            return and();
    }

}


}
