package me.snowdrop.istio.api.networking.v1beta1;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class HTTPRetryFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.HTTPRetryFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.HTTPRetryFluent<A>{

    private Integer attempts;
    private DurationBuilder perTryTimeout;
    private String retryOn;
    private Boolean retryRemoteLocalities;

    public HTTPRetryFluentImpl(){
    }
    public HTTPRetryFluentImpl(me.snowdrop.istio.api.networking.v1beta1.HTTPRetry instance){
            this.withAttempts(instance.getAttempts()); 
            this.withPerTryTimeout(instance.getPerTryTimeout()); 
            this.withRetryOn(instance.getRetryOn()); 
            this.withRetryRemoteLocalities(instance.getRetryRemoteLocalities()); 
    }

    public Integer getAttempts(){
            return this.attempts;
    }

    public A withAttempts(Integer attempts){
            this.attempts=attempts; return (A) this;
    }

    public Boolean hasAttempts(){
            return this.attempts != null;
    }

    
/**
 * This method has been deprecated, please use method buildPerTryTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getPerTryTimeout(){
            return this.perTryTimeout!=null?this.perTryTimeout.build():null;
    }

    public Duration buildPerTryTimeout(){
            return this.perTryTimeout!=null?this.perTryTimeout.build():null;
    }

    public A withPerTryTimeout(Duration perTryTimeout){
            _visitables.get("perTryTimeout").remove(this.perTryTimeout);
            if (perTryTimeout!=null){ this.perTryTimeout= new DurationBuilder(perTryTimeout); _visitables.get("perTryTimeout").add(this.perTryTimeout);} return (A) this;
    }

    public Boolean hasPerTryTimeout(){
            return this.perTryTimeout != null;
    }

    public A withNewPerTryTimeout(Integer nanos,Long seconds){
            return (A)withPerTryTimeout(new Duration(nanos, seconds));
    }

    public HTTPRetryFluent.PerTryTimeoutNested<A> withNewPerTryTimeout(){
            return new PerTryTimeoutNestedImpl();
    }

    public HTTPRetryFluent.PerTryTimeoutNested<A> withNewPerTryTimeoutLike(Duration item){
            return new PerTryTimeoutNestedImpl(item);
    }

    public HTTPRetryFluent.PerTryTimeoutNested<A> editPerTryTimeout(){
            return withNewPerTryTimeoutLike(getPerTryTimeout());
    }

    public HTTPRetryFluent.PerTryTimeoutNested<A> editOrNewPerTryTimeout(){
            return withNewPerTryTimeoutLike(getPerTryTimeout() != null ? getPerTryTimeout(): new DurationBuilder().build());
    }

    public HTTPRetryFluent.PerTryTimeoutNested<A> editOrNewPerTryTimeoutLike(Duration item){
            return withNewPerTryTimeoutLike(getPerTryTimeout() != null ? getPerTryTimeout(): item);
    }

    public String getRetryOn(){
            return this.retryOn;
    }

    public A withRetryOn(String retryOn){
            this.retryOn=retryOn; return (A) this;
    }

    public Boolean hasRetryOn(){
            return this.retryOn != null;
    }

    public A withNewRetryOn(String arg1){
            return (A)withRetryOn(new String(arg1));
    }

    public A withNewRetryOn(StringBuilder arg1){
            return (A)withRetryOn(new String(arg1));
    }

    public A withNewRetryOn(StringBuffer arg1){
            return (A)withRetryOn(new String(arg1));
    }

    public Boolean isRetryRemoteLocalities(){
            return this.retryRemoteLocalities;
    }

    public A withRetryRemoteLocalities(Boolean retryRemoteLocalities){
            this.retryRemoteLocalities=retryRemoteLocalities; return (A) this;
    }

    public Boolean hasRetryRemoteLocalities(){
            return this.retryRemoteLocalities != null;
    }

    public A withNewRetryRemoteLocalities(String arg1){
            return (A)withRetryRemoteLocalities(new Boolean(arg1));
    }

    public A withNewRetryRemoteLocalities(boolean arg1){
            return (A)withRetryRemoteLocalities(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HTTPRetryFluentImpl that = (HTTPRetryFluentImpl) o;
            if (attempts != null ? !attempts.equals(that.attempts) :that.attempts != null) return false;
            if (perTryTimeout != null ? !perTryTimeout.equals(that.perTryTimeout) :that.perTryTimeout != null) return false;
            if (retryOn != null ? !retryOn.equals(that.retryOn) :that.retryOn != null) return false;
            if (retryRemoteLocalities != null ? !retryRemoteLocalities.equals(that.retryRemoteLocalities) :that.retryRemoteLocalities != null) return false;
            return true;
    }


    public class PerTryTimeoutNestedImpl<N> extends DurationFluentImpl<HTTPRetryFluent.PerTryTimeoutNested<N>> implements HTTPRetryFluent.PerTryTimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            PerTryTimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            PerTryTimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRetryFluentImpl.this.withPerTryTimeout(builder.build());
    }
    public N endPerTryTimeout(){
            return and();
    }

}


}
