package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import me.snowdrop.istio.api.Duration;
import java.lang.Double;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;
import me.snowdrop.istio.api.DurationFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.Deprecated;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.core.JsonParser;
import java.lang.Integer;
import java.lang.StringBuffer;

public class HTTPRouteFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.HTTPRouteFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.HTTPRouteFluent<A>{

    private me.snowdrop.istio.api.networking.v1beta1.CorsPolicyBuilder corsPolicy;
    private me.snowdrop.istio.api.networking.v1beta1.DelegateBuilder delegate;
    private me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjectionBuilder fault;
    private me.snowdrop.istio.api.networking.v1beta1.HeadersBuilder headers;
    private List<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> match;
    private me.snowdrop.istio.api.networking.v1beta1.DestinationBuilder mirror;
    private Integer mirrorPercent;
    private me.snowdrop.istio.api.networking.v1beta1.PercentBuilder mirrorPercentage;
    private String name;
    private me.snowdrop.istio.api.networking.v1beta1.HTTPRedirectBuilder redirect;
    private me.snowdrop.istio.api.networking.v1beta1.HTTPRetryBuilder retries;
    private me.snowdrop.istio.api.networking.v1beta1.HTTPRewriteBuilder rewrite;
    private List<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> route;
    private DurationBuilder timeout;

    public HTTPRouteFluentImpl(){
    }
    public HTTPRouteFluentImpl(me.snowdrop.istio.api.networking.v1beta1.HTTPRoute instance){
            this.withCorsPolicy(instance.getCorsPolicy()); 
            this.withDelegate(instance.getDelegate()); 
            this.withFault(instance.getFault()); 
            this.withHeaders(instance.getHeaders()); 
            this.withMatch(instance.getMatch()); 
            this.withMirror(instance.getMirror()); 
            this.withMirrorPercent(instance.getMirrorPercent()); 
            this.withMirrorPercentage(instance.getMirrorPercentage()); 
            this.withName(instance.getName()); 
            this.withRedirect(instance.getRedirect()); 
            this.withRetries(instance.getRetries()); 
            this.withRewrite(instance.getRewrite()); 
            this.withRoute(instance.getRoute()); 
            this.withTimeout(instance.getTimeout()); 
    }

    
/**
 * This method has been deprecated, please use method buildCorsPolicy instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.CorsPolicy getCorsPolicy(){
            return this.corsPolicy!=null?this.corsPolicy.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.CorsPolicy buildCorsPolicy(){
            return this.corsPolicy!=null?this.corsPolicy.build():null;
    }

    public A withCorsPolicy(me.snowdrop.istio.api.networking.v1beta1.CorsPolicy corsPolicy){
            _visitables.get("corsPolicy").remove(this.corsPolicy);
            if (corsPolicy!=null){ this.corsPolicy= new me.snowdrop.istio.api.networking.v1beta1.CorsPolicyBuilder(corsPolicy); _visitables.get("corsPolicy").add(this.corsPolicy);} return (A) this;
    }

    public Boolean hasCorsPolicy(){
            return this.corsPolicy != null;
    }

    public HTTPRouteFluent.CorsPolicyNested<A> withNewCorsPolicy(){
            return new CorsPolicyNestedImpl();
    }

    public HTTPRouteFluent.CorsPolicyNested<A> withNewCorsPolicyLike(me.snowdrop.istio.api.networking.v1beta1.CorsPolicy item){
            return new CorsPolicyNestedImpl(item);
    }

    public HTTPRouteFluent.CorsPolicyNested<A> editCorsPolicy(){
            return withNewCorsPolicyLike(getCorsPolicy());
    }

    public HTTPRouteFluent.CorsPolicyNested<A> editOrNewCorsPolicy(){
            return withNewCorsPolicyLike(getCorsPolicy() != null ? getCorsPolicy(): new me.snowdrop.istio.api.networking.v1beta1.CorsPolicyBuilder().build());
    }

    public HTTPRouteFluent.CorsPolicyNested<A> editOrNewCorsPolicyLike(me.snowdrop.istio.api.networking.v1beta1.CorsPolicy item){
            return withNewCorsPolicyLike(getCorsPolicy() != null ? getCorsPolicy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDelegate instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.Delegate getDelegate(){
            return this.delegate!=null?this.delegate.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.Delegate buildDelegate(){
            return this.delegate!=null?this.delegate.build():null;
    }

    public A withDelegate(me.snowdrop.istio.api.networking.v1beta1.Delegate delegate){
            _visitables.get("delegate").remove(this.delegate);
            if (delegate!=null){ this.delegate= new me.snowdrop.istio.api.networking.v1beta1.DelegateBuilder(delegate); _visitables.get("delegate").add(this.delegate);} return (A) this;
    }

    public Boolean hasDelegate(){
            return this.delegate != null;
    }

    public A withNewDelegate(String name,String namespace){
            return (A)withDelegate(new Delegate(name, namespace));
    }

    public HTTPRouteFluent.DelegateNested<A> withNewDelegate(){
            return new DelegateNestedImpl();
    }

    public HTTPRouteFluent.DelegateNested<A> withNewDelegateLike(me.snowdrop.istio.api.networking.v1beta1.Delegate item){
            return new DelegateNestedImpl(item);
    }

    public HTTPRouteFluent.DelegateNested<A> editDelegate(){
            return withNewDelegateLike(getDelegate());
    }

    public HTTPRouteFluent.DelegateNested<A> editOrNewDelegate(){
            return withNewDelegateLike(getDelegate() != null ? getDelegate(): new me.snowdrop.istio.api.networking.v1beta1.DelegateBuilder().build());
    }

    public HTTPRouteFluent.DelegateNested<A> editOrNewDelegateLike(me.snowdrop.istio.api.networking.v1beta1.Delegate item){
            return withNewDelegateLike(getDelegate() != null ? getDelegate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildFault instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjection getFault(){
            return this.fault!=null?this.fault.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjection buildFault(){
            return this.fault!=null?this.fault.build():null;
    }

    public A withFault(me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjection fault){
            _visitables.get("fault").remove(this.fault);
            if (fault!=null){ this.fault= new me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjectionBuilder(fault); _visitables.get("fault").add(this.fault);} return (A) this;
    }

    public Boolean hasFault(){
            return this.fault != null;
    }

    public HTTPRouteFluent.FaultNested<A> withNewFault(){
            return new FaultNestedImpl();
    }

    public HTTPRouteFluent.FaultNested<A> withNewFaultLike(me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjection item){
            return new FaultNestedImpl(item);
    }

    public HTTPRouteFluent.FaultNested<A> editFault(){
            return withNewFaultLike(getFault());
    }

    public HTTPRouteFluent.FaultNested<A> editOrNewFault(){
            return withNewFaultLike(getFault() != null ? getFault(): new me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjectionBuilder().build());
    }

    public HTTPRouteFluent.FaultNested<A> editOrNewFaultLike(me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjection item){
            return withNewFaultLike(getFault() != null ? getFault(): item);
    }

    
/**
 * This method has been deprecated, please use method buildHeaders instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.Headers getHeaders(){
            return this.headers!=null?this.headers.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.Headers buildHeaders(){
            return this.headers!=null?this.headers.build():null;
    }

    public A withHeaders(me.snowdrop.istio.api.networking.v1beta1.Headers headers){
            _visitables.get("headers").remove(this.headers);
            if (headers!=null){ this.headers= new me.snowdrop.istio.api.networking.v1beta1.HeadersBuilder(headers); _visitables.get("headers").add(this.headers);} return (A) this;
    }

    public Boolean hasHeaders(){
            return this.headers != null;
    }

    public HTTPRouteFluent.HeadersNested<A> withNewHeaders(){
            return new HeadersNestedImpl();
    }

    public HTTPRouteFluent.HeadersNested<A> withNewHeadersLike(me.snowdrop.istio.api.networking.v1beta1.Headers item){
            return new HeadersNestedImpl(item);
    }

    public HTTPRouteFluent.HeadersNested<A> editHeaders(){
            return withNewHeadersLike(getHeaders());
    }

    public HTTPRouteFluent.HeadersNested<A> editOrNewHeaders(){
            return withNewHeadersLike(getHeaders() != null ? getHeaders(): new me.snowdrop.istio.api.networking.v1beta1.HeadersBuilder().build());
    }

    public HTTPRouteFluent.HeadersNested<A> editOrNewHeadersLike(me.snowdrop.istio.api.networking.v1beta1.Headers item){
            return withNewHeadersLike(getHeaders() != null ? getHeaders(): item);
    }

    public A addToMatch(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item){
            if (this.match == null) {this.match = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);_visitables.get("match").add(index >= 0 ? index : _visitables.get("match").size(), builder);this.match.add(index >= 0 ? index : match.size(), builder); return (A)this;
    }

    public A setToMatch(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item){
            if (this.match == null) {this.match = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);
            if (index < 0 || index >= _visitables.get("match").size()) { _visitables.get("match").add(builder); } else { _visitables.get("match").set(index, builder);}
            if (index < 0 || index >= match.size()) { match.add(builder); } else { match.set(index, builder);}
             return (A)this;
    }

    public A addToMatch(me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest... items){
            if (this.match == null) {this.match = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
    }

    public A addAllToMatch(Collection<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest> items){
            if (this.match == null) {this.match = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
    }

    public A removeFromMatch(me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest... items){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);_visitables.get("match").remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
    }

    public A removeAllFromMatch(Collection<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest> items){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(item);_visitables.get("match").remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMatch(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> predicate){
            if (match == null) return (A) this;
            final Iterator<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> each = match.iterator();
            final List visitables = _visitables.get("match");
            while (each.hasNext()) {
              me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatch instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest> getMatch(){
            return build(match);
    }

    public List<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest> buildMatch(){
            return build(match);
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest buildMatch(int index){
            return this.match.get(index).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest buildFirstMatch(){
            return this.match.get(0).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest buildLastMatch(){
            return this.match.get(match.size() - 1).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest buildMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder item: match) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder item: match) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMatch(List<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest> match){
            if (this.match != null) { _visitables.get("match").removeAll(this.match);}
            if (match != null) {this.match = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder>(); for (me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item : match){this.addToMatch(item);}} else { this.match = null;} return (A) this;
    }

    public A withMatch(me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest... match){
            if (this.match != null) {this.match.clear();}
            if (match != null) {for (me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item :match){ this.addToMatch(item);}} return (A) this;
    }

    public Boolean hasMatch(){
            return match != null && !match.isEmpty();
    }

    public HTTPRouteFluent.MatchNested<A> addNewMatch(){
            return new MatchNestedImpl();
    }

    public HTTPRouteFluent.MatchNested<A> addNewMatchLike(me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item){
            return new MatchNestedImpl(-1, item);
    }

    public HTTPRouteFluent.MatchNested<A> setNewMatchLike(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item){
            return new MatchNestedImpl(index, item);
    }

    public HTTPRouteFluent.MatchNested<A> editMatch(int index){
            if (match.size() <= index) throw new RuntimeException("Can't edit match. Index exceeds size.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public HTTPRouteFluent.MatchNested<A> editFirstMatch(){
            if (match.size() == 0) throw new RuntimeException("Can't edit first match. The list is empty.");
            return setNewMatchLike(0, buildMatch(0));
    }

    public HTTPRouteFluent.MatchNested<A> editLastMatch(){
            int index = match.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last match. The list is empty.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public HTTPRouteFluent.MatchNested<A> editMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder> predicate){
            int index = -1;
            for (int i=0;i<match.size();i++) { 
            if (predicate.apply(match.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching match. No match found.");
            return setNewMatchLike(index, buildMatch(index));
    }

    
/**
 * This method has been deprecated, please use method buildMirror instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.Destination getMirror(){
            return this.mirror!=null?this.mirror.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.Destination buildMirror(){
            return this.mirror!=null?this.mirror.build():null;
    }

    public A withMirror(me.snowdrop.istio.api.networking.v1beta1.Destination mirror){
            _visitables.get("mirror").remove(this.mirror);
            if (mirror!=null){ this.mirror= new me.snowdrop.istio.api.networking.v1beta1.DestinationBuilder(mirror); _visitables.get("mirror").add(this.mirror);} return (A) this;
    }

    public Boolean hasMirror(){
            return this.mirror != null;
    }

    public HTTPRouteFluent.MirrorNested<A> withNewMirror(){
            return new MirrorNestedImpl();
    }

    public HTTPRouteFluent.MirrorNested<A> withNewMirrorLike(me.snowdrop.istio.api.networking.v1beta1.Destination item){
            return new MirrorNestedImpl(item);
    }

    public HTTPRouteFluent.MirrorNested<A> editMirror(){
            return withNewMirrorLike(getMirror());
    }

    public HTTPRouteFluent.MirrorNested<A> editOrNewMirror(){
            return withNewMirrorLike(getMirror() != null ? getMirror(): new me.snowdrop.istio.api.networking.v1beta1.DestinationBuilder().build());
    }

    public HTTPRouteFluent.MirrorNested<A> editOrNewMirrorLike(me.snowdrop.istio.api.networking.v1beta1.Destination item){
            return withNewMirrorLike(getMirror() != null ? getMirror(): item);
    }

    public Integer getMirrorPercent(){
            return this.mirrorPercent;
    }

    public A withMirrorPercent(Integer mirrorPercent){
            this.mirrorPercent=mirrorPercent; return (A) this;
    }

    public Boolean hasMirrorPercent(){
            return this.mirrorPercent != null;
    }

    
/**
 * This method has been deprecated, please use method buildMirrorPercentage instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.Percent getMirrorPercentage(){
            return this.mirrorPercentage!=null?this.mirrorPercentage.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.Percent buildMirrorPercentage(){
            return this.mirrorPercentage!=null?this.mirrorPercentage.build():null;
    }

    public A withMirrorPercentage(me.snowdrop.istio.api.networking.v1beta1.Percent mirrorPercentage){
            _visitables.get("mirrorPercentage").remove(this.mirrorPercentage);
            if (mirrorPercentage!=null){ this.mirrorPercentage= new me.snowdrop.istio.api.networking.v1beta1.PercentBuilder(mirrorPercentage); _visitables.get("mirrorPercentage").add(this.mirrorPercentage);} return (A) this;
    }

    public Boolean hasMirrorPercentage(){
            return this.mirrorPercentage != null;
    }

    public A withNewMirrorPercentage(Double value){
            return (A)withMirrorPercentage(new Percent(value));
    }

    public HTTPRouteFluent.MirrorPercentageNested<A> withNewMirrorPercentage(){
            return new MirrorPercentageNestedImpl();
    }

    public HTTPRouteFluent.MirrorPercentageNested<A> withNewMirrorPercentageLike(me.snowdrop.istio.api.networking.v1beta1.Percent item){
            return new MirrorPercentageNestedImpl(item);
    }

    public HTTPRouteFluent.MirrorPercentageNested<A> editMirrorPercentage(){
            return withNewMirrorPercentageLike(getMirrorPercentage());
    }

    public HTTPRouteFluent.MirrorPercentageNested<A> editOrNewMirrorPercentage(){
            return withNewMirrorPercentageLike(getMirrorPercentage() != null ? getMirrorPercentage(): new me.snowdrop.istio.api.networking.v1beta1.PercentBuilder().build());
    }

    public HTTPRouteFluent.MirrorPercentageNested<A> editOrNewMirrorPercentageLike(me.snowdrop.istio.api.networking.v1beta1.Percent item){
            return withNewMirrorPercentageLike(getMirrorPercentage() != null ? getMirrorPercentage(): item);
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRedirect instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.HTTPRedirect getRedirect(){
            return this.redirect!=null?this.redirect.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRedirect buildRedirect(){
            return this.redirect!=null?this.redirect.build():null;
    }

    public A withRedirect(me.snowdrop.istio.api.networking.v1beta1.HTTPRedirect redirect){
            _visitables.get("redirect").remove(this.redirect);
            if (redirect!=null){ this.redirect= new me.snowdrop.istio.api.networking.v1beta1.HTTPRedirectBuilder(redirect); _visitables.get("redirect").add(this.redirect);} return (A) this;
    }

    public Boolean hasRedirect(){
            return this.redirect != null;
    }

    public A withNewRedirect(String authority,Integer redirectCode,String uri){
            return (A)withRedirect(new HTTPRedirect(authority, redirectCode, uri));
    }

    public HTTPRouteFluent.RedirectNested<A> withNewRedirect(){
            return new RedirectNestedImpl();
    }

    public HTTPRouteFluent.RedirectNested<A> withNewRedirectLike(me.snowdrop.istio.api.networking.v1beta1.HTTPRedirect item){
            return new RedirectNestedImpl(item);
    }

    public HTTPRouteFluent.RedirectNested<A> editRedirect(){
            return withNewRedirectLike(getRedirect());
    }

    public HTTPRouteFluent.RedirectNested<A> editOrNewRedirect(){
            return withNewRedirectLike(getRedirect() != null ? getRedirect(): new me.snowdrop.istio.api.networking.v1beta1.HTTPRedirectBuilder().build());
    }

    public HTTPRouteFluent.RedirectNested<A> editOrNewRedirectLike(me.snowdrop.istio.api.networking.v1beta1.HTTPRedirect item){
            return withNewRedirectLike(getRedirect() != null ? getRedirect(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRetries instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.HTTPRetry getRetries(){
            return this.retries!=null?this.retries.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRetry buildRetries(){
            return this.retries!=null?this.retries.build():null;
    }

    public A withRetries(me.snowdrop.istio.api.networking.v1beta1.HTTPRetry retries){
            _visitables.get("retries").remove(this.retries);
            if (retries!=null){ this.retries= new me.snowdrop.istio.api.networking.v1beta1.HTTPRetryBuilder(retries); _visitables.get("retries").add(this.retries);} return (A) this;
    }

    public Boolean hasRetries(){
            return this.retries != null;
    }

    public HTTPRouteFluent.RetriesNested<A> withNewRetries(){
            return new RetriesNestedImpl();
    }

    public HTTPRouteFluent.RetriesNested<A> withNewRetriesLike(me.snowdrop.istio.api.networking.v1beta1.HTTPRetry item){
            return new RetriesNestedImpl(item);
    }

    public HTTPRouteFluent.RetriesNested<A> editRetries(){
            return withNewRetriesLike(getRetries());
    }

    public HTTPRouteFluent.RetriesNested<A> editOrNewRetries(){
            return withNewRetriesLike(getRetries() != null ? getRetries(): new me.snowdrop.istio.api.networking.v1beta1.HTTPRetryBuilder().build());
    }

    public HTTPRouteFluent.RetriesNested<A> editOrNewRetriesLike(me.snowdrop.istio.api.networking.v1beta1.HTTPRetry item){
            return withNewRetriesLike(getRetries() != null ? getRetries(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRewrite instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.HTTPRewrite getRewrite(){
            return this.rewrite!=null?this.rewrite.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRewrite buildRewrite(){
            return this.rewrite!=null?this.rewrite.build():null;
    }

    public A withRewrite(me.snowdrop.istio.api.networking.v1beta1.HTTPRewrite rewrite){
            _visitables.get("rewrite").remove(this.rewrite);
            if (rewrite!=null){ this.rewrite= new me.snowdrop.istio.api.networking.v1beta1.HTTPRewriteBuilder(rewrite); _visitables.get("rewrite").add(this.rewrite);} return (A) this;
    }

    public Boolean hasRewrite(){
            return this.rewrite != null;
    }

    public A withNewRewrite(String authority,String uri){
            return (A)withRewrite(new HTTPRewrite(authority, uri));
    }

    public HTTPRouteFluent.RewriteNested<A> withNewRewrite(){
            return new RewriteNestedImpl();
    }

    public HTTPRouteFluent.RewriteNested<A> withNewRewriteLike(me.snowdrop.istio.api.networking.v1beta1.HTTPRewrite item){
            return new RewriteNestedImpl(item);
    }

    public HTTPRouteFluent.RewriteNested<A> editRewrite(){
            return withNewRewriteLike(getRewrite());
    }

    public HTTPRouteFluent.RewriteNested<A> editOrNewRewrite(){
            return withNewRewriteLike(getRewrite() != null ? getRewrite(): new me.snowdrop.istio.api.networking.v1beta1.HTTPRewriteBuilder().build());
    }

    public HTTPRouteFluent.RewriteNested<A> editOrNewRewriteLike(me.snowdrop.istio.api.networking.v1beta1.HTTPRewrite item){
            return withNewRewriteLike(getRewrite() != null ? getRewrite(): item);
    }

    public A addToRoute(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item){
            if (this.route == null) {this.route = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);_visitables.get("route").add(index >= 0 ? index : _visitables.get("route").size(), builder);this.route.add(index >= 0 ? index : route.size(), builder); return (A)this;
    }

    public A setToRoute(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item){
            if (this.route == null) {this.route = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);
            if (index < 0 || index >= _visitables.get("route").size()) { _visitables.get("route").add(builder); } else { _visitables.get("route").set(index, builder);}
            if (index < 0 || index >= route.size()) { route.add(builder); } else { route.set(index, builder);}
             return (A)this;
    }

    public A addToRoute(me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination... items){
            if (this.route == null) {this.route = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
    }

    public A addAllToRoute(Collection<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination> items){
            if (this.route == null) {this.route = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
    }

    public A removeFromRoute(me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination... items){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);_visitables.get("route").remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
    }

    public A removeAllFromRoute(Collection<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination> items){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(item);_visitables.get("route").remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRoute(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> predicate){
            if (route == null) return (A) this;
            final Iterator<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> each = route.iterator();
            final List visitables = _visitables.get("route");
            while (each.hasNext()) {
              me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRoute instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination> getRoute(){
            return build(route);
    }

    public List<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination> buildRoute(){
            return build(route);
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination buildRoute(int index){
            return this.route.get(index).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination buildFirstRoute(){
            return this.route.get(0).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination buildLastRoute(){
            return this.route.get(route.size() - 1).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination buildMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder item: route) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder item: route) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRoute(List<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination> route){
            if (this.route != null) { _visitables.get("route").removeAll(this.route);}
            if (route != null) {this.route = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder>(); for (me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item : route){this.addToRoute(item);}} else { this.route = null;} return (A) this;
    }

    public A withRoute(me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination... route){
            if (this.route != null) {this.route.clear();}
            if (route != null) {for (me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item :route){ this.addToRoute(item);}} return (A) this;
    }

    public Boolean hasRoute(){
            return route != null && !route.isEmpty();
    }

    public HTTPRouteFluent.RouteNested<A> addNewRoute(){
            return new RouteNestedImpl();
    }

    public HTTPRouteFluent.RouteNested<A> addNewRouteLike(me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item){
            return new RouteNestedImpl(-1, item);
    }

    public HTTPRouteFluent.RouteNested<A> setNewRouteLike(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item){
            return new RouteNestedImpl(index, item);
    }

    public HTTPRouteFluent.RouteNested<A> editRoute(int index){
            if (route.size() <= index) throw new RuntimeException("Can't edit route. Index exceeds size.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public HTTPRouteFluent.RouteNested<A> editFirstRoute(){
            if (route.size() == 0) throw new RuntimeException("Can't edit first route. The list is empty.");
            return setNewRouteLike(0, buildRoute(0));
    }

    public HTTPRouteFluent.RouteNested<A> editLastRoute(){
            int index = route.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last route. The list is empty.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public HTTPRouteFluent.RouteNested<A> editMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder> predicate){
            int index = -1;
            for (int i=0;i<route.size();i++) { 
            if (predicate.apply(route.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching route. No match found.");
            return setNewRouteLike(index, buildRoute(index));
    }

    
/**
 * This method has been deprecated, please use method buildTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getTimeout(){
            return this.timeout!=null?this.timeout.build():null;
    }

    public Duration buildTimeout(){
            return this.timeout!=null?this.timeout.build():null;
    }

    public A withTimeout(Duration timeout){
            _visitables.get("timeout").remove(this.timeout);
            if (timeout!=null){ this.timeout= new DurationBuilder(timeout); _visitables.get("timeout").add(this.timeout);} return (A) this;
    }

    public Boolean hasTimeout(){
            return this.timeout != null;
    }

    public A withNewTimeout(Integer nanos,Long seconds){
            return (A)withTimeout(new Duration(nanos, seconds));
    }

    public HTTPRouteFluent.TimeoutNested<A> withNewTimeout(){
            return new TimeoutNestedImpl();
    }

    public HTTPRouteFluent.TimeoutNested<A> withNewTimeoutLike(Duration item){
            return new TimeoutNestedImpl(item);
    }

    public HTTPRouteFluent.TimeoutNested<A> editTimeout(){
            return withNewTimeoutLike(getTimeout());
    }

    public HTTPRouteFluent.TimeoutNested<A> editOrNewTimeout(){
            return withNewTimeoutLike(getTimeout() != null ? getTimeout(): new DurationBuilder().build());
    }

    public HTTPRouteFluent.TimeoutNested<A> editOrNewTimeoutLike(Duration item){
            return withNewTimeoutLike(getTimeout() != null ? getTimeout(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HTTPRouteFluentImpl that = (HTTPRouteFluentImpl) o;
            if (corsPolicy != null ? !corsPolicy.equals(that.corsPolicy) :that.corsPolicy != null) return false;
            if (delegate != null ? !delegate.equals(that.delegate) :that.delegate != null) return false;
            if (fault != null ? !fault.equals(that.fault) :that.fault != null) return false;
            if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
            if (match != null ? !match.equals(that.match) :that.match != null) return false;
            if (mirror != null ? !mirror.equals(that.mirror) :that.mirror != null) return false;
            if (mirrorPercent != null ? !mirrorPercent.equals(that.mirrorPercent) :that.mirrorPercent != null) return false;
            if (mirrorPercentage != null ? !mirrorPercentage.equals(that.mirrorPercentage) :that.mirrorPercentage != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (redirect != null ? !redirect.equals(that.redirect) :that.redirect != null) return false;
            if (retries != null ? !retries.equals(that.retries) :that.retries != null) return false;
            if (rewrite != null ? !rewrite.equals(that.rewrite) :that.rewrite != null) return false;
            if (route != null ? !route.equals(that.route) :that.route != null) return false;
            if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
            return true;
    }


    public class CorsPolicyNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.CorsPolicyFluentImpl<HTTPRouteFluent.CorsPolicyNested<N>> implements HTTPRouteFluent.CorsPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.CorsPolicyBuilder builder;
    
            CorsPolicyNestedImpl(me.snowdrop.istio.api.networking.v1beta1.CorsPolicy item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.CorsPolicyBuilder(this, item);
            }
            CorsPolicyNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.CorsPolicyBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withCorsPolicy(builder.build());
    }
    public N endCorsPolicy(){
            return and();
    }

}
    public class DelegateNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.DelegateFluentImpl<HTTPRouteFluent.DelegateNested<N>> implements HTTPRouteFluent.DelegateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.DelegateBuilder builder;
    
            DelegateNestedImpl(me.snowdrop.istio.api.networking.v1beta1.Delegate item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.DelegateBuilder(this, item);
            }
            DelegateNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.DelegateBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withDelegate(builder.build());
    }
    public N endDelegate(){
            return and();
    }

}
    public class FaultNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjectionFluentImpl<HTTPRouteFluent.FaultNested<N>> implements HTTPRouteFluent.FaultNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjectionBuilder builder;
    
            FaultNestedImpl(me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjection item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjectionBuilder(this, item);
            }
            FaultNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPFaultInjectionBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withFault(builder.build());
    }
    public N endFault(){
            return and();
    }

}
    public class HeadersNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.HeadersFluentImpl<HTTPRouteFluent.HeadersNested<N>> implements HTTPRouteFluent.HeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.HeadersBuilder builder;
    
            HeadersNestedImpl(me.snowdrop.istio.api.networking.v1beta1.Headers item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HeadersBuilder(this, item);
            }
            HeadersNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HeadersBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withHeaders(builder.build());
    }
    public N endHeaders(){
            return and();
    }

}
    public class MatchNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestFluentImpl<HTTPRouteFluent.MatchNested<N>> implements HTTPRouteFluent.MatchNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder builder;
        private final int index;
    
            MatchNestedImpl(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequest item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(this, item);
            }
            MatchNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPMatchRequestBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.setToMatch(index,builder.build());
    }
    public N endMatch(){
            return and();
    }

}
    public class MirrorNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.DestinationFluentImpl<HTTPRouteFluent.MirrorNested<N>> implements HTTPRouteFluent.MirrorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.DestinationBuilder builder;
    
            MirrorNestedImpl(me.snowdrop.istio.api.networking.v1beta1.Destination item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.DestinationBuilder(this, item);
            }
            MirrorNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.DestinationBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withMirror(builder.build());
    }
    public N endMirror(){
            return and();
    }

}
    public class MirrorPercentageNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.PercentFluentImpl<HTTPRouteFluent.MirrorPercentageNested<N>> implements HTTPRouteFluent.MirrorPercentageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.PercentBuilder builder;
    
            MirrorPercentageNestedImpl(me.snowdrop.istio.api.networking.v1beta1.Percent item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PercentBuilder(this, item);
            }
            MirrorPercentageNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PercentBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withMirrorPercentage(builder.build());
    }
    public N endMirrorPercentage(){
            return and();
    }

}
    public class RedirectNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.HTTPRedirectFluentImpl<HTTPRouteFluent.RedirectNested<N>> implements HTTPRouteFluent.RedirectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.HTTPRedirectBuilder builder;
    
            RedirectNestedImpl(me.snowdrop.istio.api.networking.v1beta1.HTTPRedirect item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRedirectBuilder(this, item);
            }
            RedirectNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRedirectBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withRedirect(builder.build());
    }
    public N endRedirect(){
            return and();
    }

}
    public class RetriesNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.HTTPRetryFluentImpl<HTTPRouteFluent.RetriesNested<N>> implements HTTPRouteFluent.RetriesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.HTTPRetryBuilder builder;
    
            RetriesNestedImpl(me.snowdrop.istio.api.networking.v1beta1.HTTPRetry item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRetryBuilder(this, item);
            }
            RetriesNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRetryBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withRetries(builder.build());
    }
    public N endRetries(){
            return and();
    }

}
    public class RewriteNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.HTTPRewriteFluentImpl<HTTPRouteFluent.RewriteNested<N>> implements HTTPRouteFluent.RewriteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.HTTPRewriteBuilder builder;
    
            RewriteNestedImpl(me.snowdrop.istio.api.networking.v1beta1.HTTPRewrite item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRewriteBuilder(this, item);
            }
            RewriteNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRewriteBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withRewrite(builder.build());
    }
    public N endRewrite(){
            return and();
    }

}
    public class RouteNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationFluentImpl<HTTPRouteFluent.RouteNested<N>> implements HTTPRouteFluent.RouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder builder;
        private final int index;
    
            RouteNestedImpl(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestination item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(this, item);
            }
            RouteNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteDestinationBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.setToRoute(index,builder.build());
    }
    public N endRoute(){
            return and();
    }

}
    public class TimeoutNestedImpl<N> extends DurationFluentImpl<HTTPRouteFluent.TimeoutNested<N>> implements HTTPRouteFluent.TimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            TimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            TimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withTimeout(builder.build());
    }
    public N endTimeout(){
            return and();
    }

}


}
