
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "h2UpgradePolicy",
    "http1MaxPendingRequests",
    "http2MaxRequests",
    "idleTimeout",
    "maxRequestsPerConnection",
    "maxRetries"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPSettings implements Serializable
{

    @JsonProperty("h2UpgradePolicy")
    private H2UpgradePolicy h2UpgradePolicy;
    /**
     * 
     */
    @JsonProperty("http1MaxPendingRequests")
    @JsonPropertyDescription("")
    private Integer http1MaxPendingRequests;
    /**
     * 
     */
    @JsonProperty("http2MaxRequests")
    @JsonPropertyDescription("")
    private Integer http2MaxRequests;
    /**
     * 
     */
    @JsonProperty("idleTimeout")
    @JsonPropertyDescription("")
    private Duration idleTimeout;
    /**
     * 
     */
    @JsonProperty("maxRequestsPerConnection")
    @JsonPropertyDescription("")
    private Integer maxRequestsPerConnection;
    /**
     * 
     */
    @JsonProperty("maxRetries")
    @JsonPropertyDescription("")
    private Integer maxRetries;
    private final static long serialVersionUID = 1565574079858041212L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPSettings() {
    }

    /**
     * 
     * @param http2MaxRequests
     * @param maxRetries
     * @param h2UpgradePolicy
     * @param idleTimeout
     * @param http1MaxPendingRequests
     * @param maxRequestsPerConnection
     */
    public HTTPSettings(H2UpgradePolicy h2UpgradePolicy, Integer http1MaxPendingRequests, Integer http2MaxRequests, Duration idleTimeout, Integer maxRequestsPerConnection, Integer maxRetries) {
        super();
        this.h2UpgradePolicy = h2UpgradePolicy;
        this.http1MaxPendingRequests = http1MaxPendingRequests;
        this.http2MaxRequests = http2MaxRequests;
        this.idleTimeout = idleTimeout;
        this.maxRequestsPerConnection = maxRequestsPerConnection;
        this.maxRetries = maxRetries;
    }

    public H2UpgradePolicy getH2UpgradePolicy() {
        return h2UpgradePolicy;
    }

    public void setH2UpgradePolicy(H2UpgradePolicy h2UpgradePolicy) {
        this.h2UpgradePolicy = h2UpgradePolicy;
    }

    /**
     * 
     */
    public Integer getHttp1MaxPendingRequests() {
        return http1MaxPendingRequests;
    }

    /**
     * 
     */
    public void setHttp1MaxPendingRequests(Integer http1MaxPendingRequests) {
        this.http1MaxPendingRequests = http1MaxPendingRequests;
    }

    /**
     * 
     */
    public Integer getHttp2MaxRequests() {
        return http2MaxRequests;
    }

    /**
     * 
     */
    public void setHttp2MaxRequests(Integer http2MaxRequests) {
        this.http2MaxRequests = http2MaxRequests;
    }

    /**
     * 
     */
    public Duration getIdleTimeout() {
        return idleTimeout;
    }

    /**
     * 
     */
    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    /**
     * 
     */
    public Integer getMaxRequestsPerConnection() {
        return maxRequestsPerConnection;
    }

    /**
     * 
     */
    public void setMaxRequestsPerConnection(Integer maxRequestsPerConnection) {
        this.maxRequestsPerConnection = maxRequestsPerConnection;
    }

    /**
     * 
     */
    public Integer getMaxRetries() {
        return maxRetries;
    }

    /**
     * 
     */
    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

}
