package me.snowdrop.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HTTPSettingsBuilder extends me.snowdrop.istio.api.networking.v1beta1.HTTPSettingsFluentImpl<me.snowdrop.istio.api.networking.v1beta1.HTTPSettingsBuilder> implements VisitableBuilder<me.snowdrop.istio.api.networking.v1beta1.HTTPSettings,me.snowdrop.istio.api.networking.v1beta1.HTTPSettingsBuilder>{

    me.snowdrop.istio.api.networking.v1beta1.HTTPSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPSettingsBuilder(){
            this(true);
    }
    public HTTPSettingsBuilder(Boolean validationEnabled){
            this(new HTTPSettings(), validationEnabled);
    }
    public HTTPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.HTTPSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.HTTPSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPSettings(), validationEnabled);
    }
    public HTTPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.HTTPSettingsFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.HTTPSettings instance){
            this(fluent, instance, true);
    }
    public HTTPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.HTTPSettingsFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.HTTPSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withH2UpgradePolicy(instance.getH2UpgradePolicy()); 
            fluent.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests()); 
            fluent.withHttp2MaxRequests(instance.getHttp2MaxRequests()); 
            fluent.withIdleTimeout(instance.getIdleTimeout()); 
            fluent.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection()); 
            fluent.withMaxRetries(instance.getMaxRetries()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.HTTPSettings instance){
            this(instance,true);
    }
    public HTTPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.HTTPSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withH2UpgradePolicy(instance.getH2UpgradePolicy()); 
            this.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests()); 
            this.withHttp2MaxRequests(instance.getHttp2MaxRequests()); 
            this.withIdleTimeout(instance.getIdleTimeout()); 
            this.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection()); 
            this.withMaxRetries(instance.getMaxRetries()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPSettings build(){
            HTTPSettings buildable = new HTTPSettings(fluent.getH2UpgradePolicy(),fluent.getHttp1MaxPendingRequests(),fluent.getHttp2MaxRequests(),fluent.getIdleTimeout(),fluent.getMaxRequestsPerConnection(),fluent.getMaxRetries());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPSettingsBuilder that = (HTTPSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
