
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "add",
    "remove",
    "set"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HeaderOperations implements Serializable
{

    /**
     * 
     */
    @JsonProperty("add")
    @JsonPropertyDescription("")
    private Map<String, String> add;
    /**
     * 
     */
    @JsonProperty("remove")
    @JsonPropertyDescription("")
    private List<java.lang.String> remove = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("set")
    @JsonPropertyDescription("")
    private Map<String, String> set;
    private final static long serialVersionUID = 5507903917972023723L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HeaderOperations() {
    }

    /**
     * 
     * @param add
     * @param set
     * @param remove
     */
    public HeaderOperations(Map<String, String> add, List<java.lang.String> remove, Map<String, String> set) {
        super();
        this.add = add;
        this.remove = remove;
        this.set = set;
    }

    /**
     * 
     */
    public Map<String, String> getAdd() {
        return add;
    }

    /**
     * 
     */
    public void setAdd(Map<String, String> add) {
        this.add = add;
    }

    /**
     * 
     */
    public List<java.lang.String> getRemove() {
        return remove;
    }

    /**
     * 
     */
    public void setRemove(List<java.lang.String> remove) {
        this.remove = remove;
    }

    /**
     * 
     */
    public Map<String, String> getSet() {
        return set;
    }

    /**
     * 
     */
    public void setSet(Map<String, String> set) {
        this.set = set;
    }

}
