package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class HeaderOperationsFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.HeaderOperationsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.HeaderOperationsFluent<A>{

    private Map<String,String> add;
    private List<String> remove;
    private Map<String,String> set;

    public HeaderOperationsFluentImpl(){
    }
    public HeaderOperationsFluentImpl(me.snowdrop.istio.api.networking.v1beta1.HeaderOperations instance){
            this.withAdd(instance.getAdd()); 
            this.withRemove(instance.getRemove()); 
            this.withSet(instance.getSet()); 
    }

    public A addToAdd(String key,String value){
            if(this.add == null && key != null && value != null) { this.add = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.add.put(key, value);} return (A)this;
    }

    public A addToAdd(Map<String,String> map){
            if(this.add == null && map != null) { this.add = new LinkedHashMap<String,String>(); }
            if(map != null) { this.add.putAll(map);} return (A)this;
    }

    public A removeFromAdd(String key){
            if(this.add == null) { return (A) this; }
            if(key != null && this.add != null) {this.add.remove(key);} return (A)this;
    }

    public A removeFromAdd(Map<String,String> map){
            if(this.add == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.add != null){this.add.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAdd(){
            return this.add;
    }

    public A withAdd(Map<String,String> add){
            if (add == null) { this.add =  null;} else {this.add = new LinkedHashMap<String,String>(add);} return (A) this;
    }

    public Boolean hasAdd(){
            return this.add != null;
    }

    public A addToRemove(int index,String item){
            if (this.remove == null) {this.remove = new ArrayList<String>();}
            this.remove.add(index, item);
            return (A)this;
    }

    public A setToRemove(int index,String item){
            if (this.remove == null) {this.remove = new ArrayList<String>();}
            this.remove.set(index, item); return (A)this;
    }

    public A addToRemove(String... items){
            if (this.remove == null) {this.remove = new ArrayList<String>();}
            for (String item : items) {this.remove.add(item);} return (A)this;
    }

    public A addAllToRemove(Collection<String> items){
            if (this.remove == null) {this.remove = new ArrayList<String>();}
            for (String item : items) {this.remove.add(item);} return (A)this;
    }

    public A removeFromRemove(String... items){
            for (String item : items) {if (this.remove!= null){ this.remove.remove(item);}} return (A)this;
    }

    public A removeAllFromRemove(Collection<String> items){
            for (String item : items) {if (this.remove!= null){ this.remove.remove(item);}} return (A)this;
    }

    public List<String> getRemove(){
            return this.remove;
    }

    public String getRemoves(int index){
            return this.remove.get(index);
    }

    public String getFirstRemoves(){
            return this.remove.get(0);
    }

    public String getLastRemoves(){
            return this.remove.get(remove.size() - 1);
    }

    public String getMatchingRemoves(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: remove) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRemoves(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: remove) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRemove(List<String> remove){
            if (this.remove != null) { _visitables.get("remove").removeAll(this.remove);}
            if (remove != null) {this.remove = new ArrayList<String>(); for (String item : remove){this.addToRemove(item);}} else { this.remove = null;} return (A) this;
    }

    public A withRemove(String... remove){
            if (this.remove != null) {this.remove.clear();}
            if (remove != null) {for (String item :remove){ this.addToRemove(item);}} return (A) this;
    }

    public Boolean hasRemove(){
            return remove != null && !remove.isEmpty();
    }

    public A addNewRemoves(String arg1){
            return (A)addToRemove(new String(arg1));
    }

    public A addNewRemoves(StringBuilder arg1){
            return (A)addToRemove(new String(arg1));
    }

    public A addNewRemoves(StringBuffer arg1){
            return (A)addToRemove(new String(arg1));
    }

    public A addToSet(String key,String value){
            if(this.set == null && key != null && value != null) { this.set = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.set.put(key, value);} return (A)this;
    }

    public A addToSet(Map<String,String> map){
            if(this.set == null && map != null) { this.set = new LinkedHashMap<String,String>(); }
            if(map != null) { this.set.putAll(map);} return (A)this;
    }

    public A removeFromSet(String key){
            if(this.set == null) { return (A) this; }
            if(key != null && this.set != null) {this.set.remove(key);} return (A)this;
    }

    public A removeFromSet(Map<String,String> map){
            if(this.set == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.set != null){this.set.remove(key);}}} return (A)this;
    }

    public Map<String,String> getSet(){
            return this.set;
    }

    public A withSet(Map<String,String> set){
            if (set == null) { this.set =  null;} else {this.set = new LinkedHashMap<String,String>(set);} return (A) this;
    }

    public Boolean hasSet(){
            return this.set != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HeaderOperationsFluentImpl that = (HeaderOperationsFluentImpl) o;
            if (add != null ? !add.equals(that.add) :that.add != null) return false;
            if (remove != null ? !remove.equals(that.remove) :that.remove != null) return false;
            if (set != null ? !set.equals(that.set) :that.set != null) return false;
            return true;
    }




}
