
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1beta1.ConsistentHashLB.HashKey;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "httpCookie"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HttpCookieHashKey implements Serializable, HashKey
{

    /**
     * 
     */
    @JsonProperty("httpCookie")
    @JsonPropertyDescription("")
    private HTTPCookie httpCookie;
    private final static long serialVersionUID = -9001115942176967150L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HttpCookieHashKey() {
    }

    /**
     * 
     * @param httpCookie
     */
    public HttpCookieHashKey(HTTPCookie httpCookie) {
        super();
        this.httpCookie = httpCookie;
    }

    /**
     * 
     */
    public HTTPCookie getHttpCookie() {
        return httpCookie;
    }

    /**
     * 
     */
    public void setHttpCookie(HTTPCookie httpCookie) {
        this.httpCookie = httpCookie;
    }

}
