
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1beta1.Abort.ErrorType;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "httpStatus"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HttpStatusErrorType implements Serializable, ErrorType
{

    /**
     * 
     */
    @JsonProperty("httpStatus")
    @JsonPropertyDescription("")
    private Integer httpStatus;
    private final static long serialVersionUID = -4939190427567229341L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HttpStatusErrorType() {
    }

    /**
     * 
     * @param httpStatus
     */
    public HttpStatusErrorType(Integer httpStatus) {
        super();
        this.httpStatus = httpStatus;
    }

    /**
     * 
     */
    public Integer getHttpStatus() {
        return httpStatus;
    }

    /**
     * 
     */
    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }

}
