
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "bind",
    "captureMode",
    "hosts",
    "port"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class IstioEgressListener implements Serializable
{

    /**
     * 
     */
    @JsonProperty("bind")
    @JsonPropertyDescription("")
    private String bind;
    @JsonProperty("captureMode")
    private CaptureMode captureMode;
    /**
     * 
     */
    @JsonProperty("hosts")
    @JsonPropertyDescription("")
    private List<String> hosts = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Port port;
    private final static long serialVersionUID = -5052631008044938261L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public IstioEgressListener() {
    }

    /**
     * 
     * @param bind
     * @param port
     * @param hosts
     * @param captureMode
     */
    public IstioEgressListener(String bind, CaptureMode captureMode, List<String> hosts, Port port) {
        super();
        this.bind = bind;
        this.captureMode = captureMode;
        this.hosts = hosts;
        this.port = port;
    }

    /**
     * 
     */
    public String getBind() {
        return bind;
    }

    /**
     * 
     */
    public void setBind(String bind) {
        this.bind = bind;
    }

    public CaptureMode getCaptureMode() {
        return captureMode;
    }

    public void setCaptureMode(CaptureMode captureMode) {
        this.captureMode = captureMode;
    }

    /**
     * 
     */
    public List<String> getHosts() {
        return hosts;
    }

    /**
     * 
     */
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    /**
     * 
     */
    public Port getPort() {
        return port;
    }

    /**
     * 
     */
    public void setPort(Port port) {
        this.port = port;
    }

}
