
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "bind",
    "captureMode",
    "defaultEndpoint",
    "port"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class IstioIngressListener implements Serializable
{

    /**
     * 
     */
    @JsonProperty("bind")
    @JsonPropertyDescription("")
    private String bind;
    @JsonProperty("captureMode")
    private CaptureMode captureMode;
    /**
     * 
     */
    @JsonProperty("defaultEndpoint")
    @JsonPropertyDescription("")
    private String defaultEndpoint;
    /**
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Port port;
    private final static long serialVersionUID = 7528766330218195179L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public IstioIngressListener() {
    }

    /**
     * 
     * @param bind
     * @param port
     * @param defaultEndpoint
     * @param captureMode
     */
    public IstioIngressListener(String bind, CaptureMode captureMode, String defaultEndpoint, Port port) {
        super();
        this.bind = bind;
        this.captureMode = captureMode;
        this.defaultEndpoint = defaultEndpoint;
        this.port = port;
    }

    /**
     * 
     */
    public String getBind() {
        return bind;
    }

    /**
     * 
     */
    public void setBind(String bind) {
        this.bind = bind;
    }

    public CaptureMode getCaptureMode() {
        return captureMode;
    }

    public void setCaptureMode(CaptureMode captureMode) {
        this.captureMode = captureMode;
    }

    /**
     * 
     */
    public String getDefaultEndpoint() {
        return defaultEndpoint;
    }

    /**
     * 
     */
    public void setDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    /**
     * 
     */
    public Port getPort() {
        return port;
    }

    /**
     * 
     */
    public void setPort(Port port) {
        this.port = port;
    }

}
