package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class IstioIngressListenerFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerFluent<A>{

    private String bind;
    private me.snowdrop.istio.api.networking.v1beta1.CaptureMode captureMode;
    private String defaultEndpoint;
    private me.snowdrop.istio.api.networking.v1beta1.PortBuilder port;

    public IstioIngressListenerFluentImpl(){
    }
    public IstioIngressListenerFluentImpl(me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener instance){
            this.withBind(instance.getBind()); 
            this.withCaptureMode(instance.getCaptureMode()); 
            this.withDefaultEndpoint(instance.getDefaultEndpoint()); 
            this.withPort(instance.getPort()); 
    }

    public String getBind(){
            return this.bind;
    }

    public A withBind(String bind){
            this.bind=bind; return (A) this;
    }

    public Boolean hasBind(){
            return this.bind != null;
    }

    public A withNewBind(String arg1){
            return (A)withBind(new String(arg1));
    }

    public A withNewBind(StringBuilder arg1){
            return (A)withBind(new String(arg1));
    }

    public A withNewBind(StringBuffer arg1){
            return (A)withBind(new String(arg1));
    }

    public me.snowdrop.istio.api.networking.v1beta1.CaptureMode getCaptureMode(){
            return this.captureMode;
    }

    public A withCaptureMode(me.snowdrop.istio.api.networking.v1beta1.CaptureMode captureMode){
            this.captureMode=captureMode; return (A) this;
    }

    public Boolean hasCaptureMode(){
            return this.captureMode != null;
    }

    public String getDefaultEndpoint(){
            return this.defaultEndpoint;
    }

    public A withDefaultEndpoint(String defaultEndpoint){
            this.defaultEndpoint=defaultEndpoint; return (A) this;
    }

    public Boolean hasDefaultEndpoint(){
            return this.defaultEndpoint != null;
    }

    public A withNewDefaultEndpoint(String arg1){
            return (A)withDefaultEndpoint(new String(arg1));
    }

    public A withNewDefaultEndpoint(StringBuilder arg1){
            return (A)withDefaultEndpoint(new String(arg1));
    }

    public A withNewDefaultEndpoint(StringBuffer arg1){
            return (A)withDefaultEndpoint(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.Port getPort(){
            return this.port!=null?this.port.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.Port buildPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(me.snowdrop.istio.api.networking.v1beta1.Port port){
            _visitables.get("port").remove(this.port);
            if (port!=null){ this.port= new me.snowdrop.istio.api.networking.v1beta1.PortBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNewPort(String name,Integer number,String protocol,Integer targetPort){
            return (A)withPort(new Port(name, number, protocol, targetPort));
    }

    public IstioIngressListenerFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public IstioIngressListenerFluent.PortNested<A> withNewPortLike(me.snowdrop.istio.api.networking.v1beta1.Port item){
            return new PortNestedImpl(item);
    }

    public IstioIngressListenerFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public IstioIngressListenerFluent.PortNested<A> editOrNewPort(){
            return withNewPortLike(getPort() != null ? getPort(): new me.snowdrop.istio.api.networking.v1beta1.PortBuilder().build());
    }

    public IstioIngressListenerFluent.PortNested<A> editOrNewPortLike(me.snowdrop.istio.api.networking.v1beta1.Port item){
            return withNewPortLike(getPort() != null ? getPort(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            IstioIngressListenerFluentImpl that = (IstioIngressListenerFluentImpl) o;
            if (bind != null ? !bind.equals(that.bind) :that.bind != null) return false;
            if (captureMode != null ? !captureMode.equals(that.captureMode) :that.captureMode != null) return false;
            if (defaultEndpoint != null ? !defaultEndpoint.equals(that.defaultEndpoint) :that.defaultEndpoint != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            return true;
    }


    public class PortNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.PortFluentImpl<IstioIngressListenerFluent.PortNested<N>> implements IstioIngressListenerFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.PortBuilder builder;
    
            PortNestedImpl(me.snowdrop.istio.api.networking.v1beta1.Port item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PortBuilder(this, item);
            }
            PortNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PortBuilder(this);
            }
    
    public N and(){
            return (N) IstioIngressListenerFluentImpl.this.withPort(builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
