
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "lbPolicy",
    "localityLbSetting"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class LoadBalancerSettings implements Serializable
{

    @JsonProperty("lbPolicy")
    @JsonUnwrapped
    private me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings.LbPolicy lbPolicy;
    /**
     * 
     */
    @JsonProperty("localityLbSetting")
    @JsonPropertyDescription("")
    private LocalityLoadBalancerSetting localityLbSetting;
    private final static long serialVersionUID = 1027350892521258125L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LoadBalancerSettings() {
    }

    /**
     * 
     * @param localityLbSetting
     * @param lbPolicy
     */
    public LoadBalancerSettings(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings.LbPolicy lbPolicy, LocalityLoadBalancerSetting localityLbSetting) {
        super();
        this.lbPolicy = lbPolicy;
        this.localityLbSetting = localityLbSetting;
    }

    public me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings.LbPolicy getLbPolicy() {
        return lbPolicy;
    }

    public void setLbPolicy(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings.LbPolicy lbPolicy) {
        this.lbPolicy = lbPolicy;
    }

    /**
     * 
     */
    public LocalityLoadBalancerSetting getLocalityLbSetting() {
        return localityLbSetting;
    }

    /**
     * 
     */
    public void setLocalityLbSetting(LocalityLoadBalancerSetting localityLbSetting) {
        this.localityLbSetting = localityLbSetting;
    }

    public interface LbPolicy extends Serializable
    {


    }

}
