package me.snowdrop.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LoadBalancerSettingsBuilder extends me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsFluentImpl<me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder> implements VisitableBuilder<me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings,me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder>{

    me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerSettingsBuilder(){
            this(true);
    }
    public LoadBalancerSettingsBuilder(Boolean validationEnabled){
            this(new LoadBalancerSettings(), validationEnabled);
    }
    public LoadBalancerSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public LoadBalancerSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LoadBalancerSettings(), validationEnabled);
    }
    public LoadBalancerSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings instance){
            this(fluent, instance, true);
    }
    public LoadBalancerSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLbPolicy(instance.getLbPolicy()); 
            fluent.withLocalityLbSetting(instance.getLocalityLbSetting()); 
            this.validationEnabled = validationEnabled; 
    }
    public LoadBalancerSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings instance){
            this(instance,true);
    }
    public LoadBalancerSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLbPolicy(instance.getLbPolicy()); 
            this.withLocalityLbSetting(instance.getLocalityLbSetting()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings build(){
            LoadBalancerSettings buildable = new LoadBalancerSettings(fluent.getLbPolicy(),fluent.getLocalityLbSetting());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LoadBalancerSettingsBuilder that = (LoadBalancerSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
