
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "egressProxy",
    "mode"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class OutboundTrafficPolicy implements Serializable
{

    /**
     * 
     */
    @JsonProperty("egressProxy")
    @JsonPropertyDescription("")
    private Destination egressProxy;
    @JsonProperty("mode")
    private OutboundTrafficPolicyMode mode;
    private final static long serialVersionUID = -7719295431505187043L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OutboundTrafficPolicy() {
    }

    /**
     * 
     * @param mode
     * @param egressProxy
     */
    public OutboundTrafficPolicy(Destination egressProxy, OutboundTrafficPolicyMode mode) {
        super();
        this.egressProxy = egressProxy;
        this.mode = mode;
    }

    /**
     * 
     */
    public Destination getEgressProxy() {
        return egressProxy;
    }

    /**
     * 
     */
    public void setEgressProxy(Destination egressProxy) {
        this.egressProxy = egressProxy;
    }

    public OutboundTrafficPolicyMode getMode() {
        return mode;
    }

    public void setMode(OutboundTrafficPolicyMode mode) {
        this.mode = mode;
    }

}
