
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "baseEjectionTime",
    "consecutive5xxErrors",
    "consecutiveErrors",
    "consecutiveGatewayErrors",
    "interval",
    "maxEjectionPercent",
    "minHealthPercent"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class OutlierDetection implements Serializable
{

    /**
     * 
     */
    @JsonProperty("baseEjectionTime")
    @JsonPropertyDescription("")
    private Duration baseEjectionTime;
    @JsonProperty("consecutive5xxErrors")
    private Integer consecutive5xxErrors;
    /**
     * 
     */
    @JsonProperty("consecutiveErrors")
    @JsonPropertyDescription("")
    private java.lang.Integer consecutiveErrors;
    @JsonProperty("consecutiveGatewayErrors")
    private Integer consecutiveGatewayErrors;
    /**
     * 
     */
    @JsonProperty("interval")
    @JsonPropertyDescription("")
    private Duration interval;
    /**
     * 
     */
    @JsonProperty("maxEjectionPercent")
    @JsonPropertyDescription("")
    private java.lang.Integer maxEjectionPercent;
    /**
     * 
     */
    @JsonProperty("minHealthPercent")
    @JsonPropertyDescription("")
    private java.lang.Integer minHealthPercent;
    private final static long serialVersionUID = -84816460594199261L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OutlierDetection() {
    }

    /**
     * 
     * @param minHealthPercent
     * @param baseEjectionTime
     * @param consecutive5xxErrors
     * @param consecutiveErrors
     * @param consecutiveGatewayErrors
     * @param interval
     * @param maxEjectionPercent
     */
    public OutlierDetection(Duration baseEjectionTime, Integer consecutive5xxErrors, java.lang.Integer consecutiveErrors, Integer consecutiveGatewayErrors, Duration interval, java.lang.Integer maxEjectionPercent, java.lang.Integer minHealthPercent) {
        super();
        this.baseEjectionTime = baseEjectionTime;
        this.consecutive5xxErrors = consecutive5xxErrors;
        this.consecutiveErrors = consecutiveErrors;
        this.consecutiveGatewayErrors = consecutiveGatewayErrors;
        this.interval = interval;
        this.maxEjectionPercent = maxEjectionPercent;
        this.minHealthPercent = minHealthPercent;
    }

    /**
     * 
     */
    public Duration getBaseEjectionTime() {
        return baseEjectionTime;
    }

    /**
     * 
     */
    public void setBaseEjectionTime(Duration baseEjectionTime) {
        this.baseEjectionTime = baseEjectionTime;
    }

    public Integer getConsecutive5xxErrors() {
        return consecutive5xxErrors;
    }

    public void setConsecutive5xxErrors(Integer consecutive5xxErrors) {
        this.consecutive5xxErrors = consecutive5xxErrors;
    }

    /**
     * 
     */
    public java.lang.Integer getConsecutiveErrors() {
        return consecutiveErrors;
    }

    /**
     * 
     */
    public void setConsecutiveErrors(java.lang.Integer consecutiveErrors) {
        this.consecutiveErrors = consecutiveErrors;
    }

    public Integer getConsecutiveGatewayErrors() {
        return consecutiveGatewayErrors;
    }

    public void setConsecutiveGatewayErrors(Integer consecutiveGatewayErrors) {
        this.consecutiveGatewayErrors = consecutiveGatewayErrors;
    }

    /**
     * 
     */
    public Duration getInterval() {
        return interval;
    }

    /**
     * 
     */
    public void setInterval(Duration interval) {
        this.interval = interval;
    }

    /**
     * 
     */
    public java.lang.Integer getMaxEjectionPercent() {
        return maxEjectionPercent;
    }

    /**
     * 
     */
    public void setMaxEjectionPercent(java.lang.Integer maxEjectionPercent) {
        this.maxEjectionPercent = maxEjectionPercent;
    }

    /**
     * 
     */
    public java.lang.Integer getMinHealthPercent() {
        return minHealthPercent;
    }

    /**
     * 
     */
    public void setMinHealthPercent(java.lang.Integer minHealthPercent) {
        this.minHealthPercent = minHealthPercent;
    }

}
