
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "name",
    "number",
    "protocol",
    "targetPort"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Port implements Serializable
{

    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("number")
    @JsonPropertyDescription("")
    private Integer number;
    /**
     * 
     */
    @JsonProperty("protocol")
    @JsonPropertyDescription("")
    private String protocol;
    /**
     * 
     */
    @JsonProperty("targetPort")
    @JsonPropertyDescription("")
    private Integer targetPort;
    private final static long serialVersionUID = 3834019771308869286L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Port() {
    }

    /**
     * 
     * @param number
     * @param protocol
     * @param name
     * @param targetPort
     */
    public Port(String name, Integer number, String protocol, Integer targetPort) {
        super();
        this.name = name;
        this.number = number;
        this.protocol = protocol;
        this.targetPort = targetPort;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public Integer getNumber() {
        return number;
    }

    /**
     * 
     */
    public void setNumber(Integer number) {
        this.number = number;
    }

    /**
     * 
     */
    public String getProtocol() {
        return protocol;
    }

    /**
     * 
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * 
     */
    public Integer getTargetPort() {
        return targetPort;
    }

    /**
     * 
     */
    public void setTargetPort(Integer targetPort) {
        this.targetPort = targetPort;
    }

}
